# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-06-08 10:18
from __future__ import unicode_literals

from django.db import migrations

from smarttv.droideka.proxy.models import get_entity_actual_version
from smarttv.droideka.utils import PlatformType


def add_initial_platforms(apps, schema_editor):
    PlatformModel = apps.get_model("proxy", "PlatformModel")
    PlatformModel(platform_type=PlatformType.ANY).save()
    PlatformModel(platform_type=PlatformType.NONE).save()


def remove_initial_platforms(apps, schema_editor):
    PlatformModel = apps.get_model("proxy", "PlatformModel")
    PlatformModel.objects.filter(platform_type__in=(PlatformType.ANY, PlatformType.NONE)).delete()


def copy_categories_to_extended_categories(apps, schema_editor):
    Category = apps.get_model("proxy", "Category")
    CategoryExtended = apps.get_model("proxy", "CategoryExtended")
    PlatformModel = apps.get_model("proxy", "PlatformModel")

    any_platform = PlatformModel.objects.filter(platform_type=PlatformType.ANY).first()
    none_platform = PlatformModel.objects.filter(platform_type=PlatformType.NONE).first()

    actual_version = get_entity_actual_version(Category.get_entity())
    if not actual_version:
        return
    actual_version = actual_version.version
    newest_categories = Category.objects.filter(version=actual_version)
    for category in newest_categories:
        extended_category = CategoryExtended(
            category_id=category.category_id,
            title=category.title,
            icon_s3_key=category.icon_s3_key,
            rank=category.rank,
            parent_category_id=None,
            visible=True,
            version=1
        )
        extended_category.save()
        extended_category.include_platforms.add(any_platform)
        extended_category.exclude_platforms.add(none_platform)
        extended_category.above_platforms.add(none_platform)
        extended_category.below_platforms.add(none_platform)


def remove_categories_from_extended_categories(apps, schema_editor):
    CategoryExtended = apps.get_model("proxy", "CategoryExtended")
    CategoryExtended.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('proxy', '0011_auto_20200608_1906'),
    ]

    operations = [
        migrations.RunPython(add_initial_platforms, reverse_code=remove_initial_platforms),
        migrations.RunPython(copy_categories_to_extended_categories,
                             reverse_code=remove_categories_from_extended_categories),
    ]
