# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-06-18 13:18
from __future__ import unicode_literals

from django.db import migrations

from smarttv.droideka.proxy.models import get_entity_actual_version
from smarttv.droideka.utils import PlatformType


def copy_categories_to_extended_categories(apps, schema_editor):
    Category = apps.get_model("proxy", "Category")
    CategoryExtendedEditable = apps.get_model("proxy", "CategoryExtendedEditable")
    CategoryExtended = apps.get_model("proxy", "CategoryExtended")
    PlatformModel = apps.get_model("proxy", "PlatformModel")

    any_platform = PlatformModel.objects.filter(platform_type=PlatformType.ANY).first()
    none_platform = PlatformModel.objects.filter(platform_type=PlatformType.NONE).first()

    actual_version = get_entity_actual_version(Category.get_entity())
    if not actual_version:
        return
    actual_version = actual_version.version
    newest_categories = Category.objects.filter(version=actual_version)

    for category in newest_categories:
        extended_editable_category = CategoryExtendedEditable(
            category_id=category.category_id,
            title=category.title,
            icon_s3_key=category.icon_s3_key,
            rank=category.rank,
            visible=True
        )
        extended_editable_category.save()

        extended_category = CategoryExtended(
            category_id=category.category_id,
            title=category.title,
            icon_s3_key=category.icon_s3_key,
            rank=category.rank
        )
        extended_category.save()

        extended_editable_category.include_platforms.add(any_platform)
        extended_category.include_platforms.add(any_platform)

        extended_editable_category.exclude_platforms.add(none_platform)
        extended_category.exclude_platforms.add(none_platform)

        extended_editable_category.above_platforms.add(none_platform)
        extended_category.above_platforms.add(none_platform)

        extended_editable_category.below_platforms.add(none_platform)
        extended_category.below_platforms.add(none_platform)


def remove_categories_from_extended_categories(apps, schema_editor):
    CategoryExtended = apps.get_model("proxy", "CategoryExtended")
    CategoryExtended.exclude_platforms.through.objects.all().delete()
    CategoryExtended.include_platforms.through.objects.all().delete()
    CategoryExtended.above_platforms.through.objects.all().delete()
    CategoryExtended.below_platforms.through.objects.all().delete()
    CategoryExtended.objects.all().delete()

    CategoryExtendedEditable = apps.get_model("proxy", "CategoryExtendedEditable")
    CategoryExtendedEditable.exclude_platforms.through.objects.all().delete()
    CategoryExtendedEditable.include_platforms.through.objects.all().delete()
    CategoryExtendedEditable.above_platforms.through.objects.all().delete()
    CategoryExtendedEditable.below_platforms.through.objects.all().delete()
    CategoryExtendedEditable.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('proxy', '0014_categoryextended_categoryextendededitable'),
    ]

    operations = [
        migrations.RunPython(copy_categories_to_extended_categories,
                             reverse_code=remove_categories_from_extended_categories),
    ]
