# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-07-08 10:58
from __future__ import unicode_literals

from django.db import migrations, models
import uuid


# noinspection PyPep8Naming
def fill_kp_gifts_given(apps, schema_editor):
    Device = apps.get_model('proxy', 'Device')
    Device.objects.filter(kp_gifts_given__isnull=True).all().update(kp_gifts_given=False)


# noinspection PyPep8Naming
def fill_kp_gifts_id(apps, schema_editor):
    Device = apps.get_model('proxy', 'Device')
    for device in Device.objects.filter(kp_gifts_id__isnull=True).all():
        device.kp_gifts_id = uuid.uuid4()
        device.save()


class Migration(migrations.Migration):
    dependencies = [
        ('proxy', '0019_auto_20200625_1512'),
    ]

    operations = [
        migrations.AddField(
            model_name='device',
            name='hardware_id',
            field=models.CharField(max_length=256, null=True, unique=True, verbose_name='ID телевизора'),
        ),
        migrations.RunPython(
            code=fill_kp_gifts_given,
            reverse_code=migrations.RunPython.noop
        ),
        migrations.AlterField(
            model_name='device',
            name='kp_gifts_given',
            field=models.BooleanField(default=False),
        ),
        migrations.RunPython(
            code=fill_kp_gifts_id,
            reverse_code=migrations.RunPython.noop
        ),
        migrations.AlterField(
            model_name='device',
            name='kp_gifts_id',
            field=models.UUIDField(default=uuid.uuid4),
        ),
        migrations.AlterField(
            model_name='device',
            name='serial_number',
            field=models.CharField(max_length=256, null=True, verbose_name='Серийный номер'),
        ),
        migrations.AddIndex(
            model_name='device',
            index=models.Index(fields=['hardware_id'], name='proxy_devic_hardwar_a6cecc_idx'),
        ),
    ]
