# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-07-17 22:24
from __future__ import unicode_literals

from django.db import migrations, models
from smarttv.droideka.proxy.models import calculate_hardware_id


# noinspection PyPep8Naming
def fill_hardware_ids(apps, schema_editor):
    Device = apps.get_model('proxy', 'Device')
    for device in Device.objects.filter(hardware_id__isnull=True).all():
        device.hardware_id = calculate_hardware_id(device.ethernet_mac, device.wifi_mac)
        device.save()


class Migration(migrations.Migration):
    dependencies = [
        ('proxy', '0020_auto_20200708_1358'),
    ]

    operations = [
        migrations.RunPython(
            code=fill_hardware_ids,
            reverse_code=migrations.RunPython.noop
        ),
        migrations.AlterField(
            model_name='device',
            name='hardware_id',
            field=models.CharField(max_length=256, unique=True, verbose_name='ID телевизора'),
        ),
    ]
