# Generated by Django 2.2.16 on 2020-10-02 11:04

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
from django.db import models


def get_general_constructor_fields_args(src_category):
    return {
        'category_id': src_category.category_id,
        'title': src_category.title,
        'icon_s3_key': src_category.icon_s3_key,
        'rank': src_category.rank,
        'position': src_category.position,
        'thumbnail_s3_key': src_category.thumbnail_s3_key,
        'logo_s3_key': src_category.logo_s3_key,
        'banner_S3_key': src_category.banner_S3_key,
        'description': src_category.description,
        'content_type': src_category.content_type,
    }


def copy_categories(apps, schema_editor):
    models = ((True, apps.get_model('proxy', 'CategoryExtendedEditable'), apps.get_model('proxy', 'Category2Editable')),
              (False, apps.get_model('proxy', 'CategoryExtended'), apps.get_model('proxy', 'Category2')))
    id_stub = 1
    for is_editable, src_model, dst_model in models:
        new_models = []
        for src_category in src_model.objects.all():
            general_constructor_args = get_general_constructor_fields_args(src_category)
            if is_editable:
                general_constructor_args['visible'] = src_category.visible
            else:
                general_constructor_args['id'] = id_stub
                id_stub += 1
            new_models.append(dst_model(**general_constructor_args))
        if new_models:
            dst_model.objects.bulk_create(new_models)


def revert_copying_categories(apps, schema_editor):
    apps.get_model('proxy', 'Category2Editable').objects.all().delete()
    apps.get_model('proxy', 'Category2').objects.all().delete()


def copy_parent_category_ids(apps, schema_editor):
    models = ((apps.get_model('proxy', 'CategoryExtendedEditable'), apps.get_model('proxy', 'Category2Editable')),
              (apps.get_model('proxy', 'CategoryExtended'), apps.get_model('proxy', 'Category2')))
    for src_model, dst_model in models:
        updated_models = []
        for src_category in src_model.objects.all():
            if src_category.parent_category_id:
                target_model = dst_model.objects.filter(category_id=src_category.category_id).first()
                target_model.parent_category = dst_model.objects.filter(category_id=src_category.parent_category_id).first()
                updated_models.append(target_model)
        if updated_models:
            dst_model.objects.bulk_update(updated_models, ['parent_category'])


def erase_parent_category_for_new_model(apps, schema_editor):
    models = (apps.get_model('proxy', 'Category2Editable'), apps.get_model('proxy', 'Category2'))

    for model in models:
        updated_models = []
        for category in model.objects.filter(parent_category_id__isnull=False):
            category.parent_category = None
            updated_models.append(category)
        if updated_models:
            model.objects.bulk_update(updated_models, ['parent_category'])


def copy_platforms(apps, schema_editor):
    models = ((apps.get_model('proxy', 'CategoryExtendedEditable'), apps.get_model('proxy', 'Category2Editable')),
              (apps.get_model('proxy', 'CategoryExtended'), apps.get_model('proxy', 'Category2')))
    for src_model, dst_model in models:
        for src_category in src_model.objects.all():
            platform_attrs = ('exclude_platforms', 'include_platforms', 'above_platforms', 'below_platforms',)
            dst_category = dst_model.objects.filter(category_id=src_category.category_id).first()
            for attribute in platform_attrs:
                for platform in getattr(src_category, attribute).all():
                    getattr(dst_category, attribute).add(platform)


def erase_platforms(apps, schema_editor):
    for model in (apps.get_model('proxy', 'Category2Editable'), apps.get_model('proxy', 'Category2')):
        model.exclude_platforms.through.objects.all().delete()
        model.include_platforms.through.objects.all().delete()
        model.above_platforms.through.objects.all().delete()
        model.below_platforms.through.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('proxy', '0025_auto_20200914_1731'),
    ]

    operations = [
        migrations.CreateModel(
            name='Category2Editable',
            fields=[
                ('category_id', models.CharField(max_length=64, verbose_name='ID категории в сторонней системе')),
                ('title', models.CharField(max_length=128, verbose_name='Имя категории')),
                ('icon_s3_key', models.TextField(blank=True, default='', verbose_name='Key S3 иконки')),
                ('rank', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1)], verbose_name='Целое число для задания порядка элементов(чтобы можно было посортировать)')),
                ('position', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1)], verbose_name='Целое число для задания абсолютной позиции в выдаче, куда встраивается категория')),
                ('thumbnail_s3_key', models.TextField(blank=True, null=True, verbose_name='Ключ S3 превью')),
                ('logo_s3_key', models.TextField(blank=True, default='', verbose_name='Ключ S3 логотипа')),
                ('banner_S3_key', models.TextField(blank=True, default='', verbose_name='Key S3 баннера')),
                ('description', models.TextField(blank=True, default='', verbose_name='Описание категории')),
                ('content_type', models.TextField(blank=True, choices=[('', 'VH category item'), ('vh_carousel', 'VH carousel'), ('external_kp', 'Kinopoisk carousel'), ('external_category_kp', 'Kinopoisk category'), ('embedded_section', 'Embedded section')], default='', verbose_name='Тип категории')),
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='Внутренний ID категории')),
                ('visible', models.BooleanField(default=True)),
                ('above_platforms', models.ManyToManyField(related_name='proxy_category2editable_above_platforms', related_query_name='proxy_category2editables_above', to='proxy.PlatformModel')),
                ('below_platforms', models.ManyToManyField(related_name='proxy_category2editable_below_platforms', related_query_name='proxy_category2editables_below', to='proxy.PlatformModel')),
                ('exclude_platforms', models.ManyToManyField(related_name='proxy_category2editable_exclude_platforms', related_query_name='proxy_category2editables_exclude', to='proxy.PlatformModel')),
                ('include_platforms', models.ManyToManyField(related_name='proxy_category2editable_include_platforms', related_query_name='proxy_category2editables_include', to='proxy.PlatformModel')),
                ('parent_category', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='proxy.Category2Editable')),
            ],
            options={
                'verbose_name_plural': 'Editable categories',
                'ordering': ('position', 'rank'),
            },
        ),
        migrations.CreateModel(
            name='Category2',
            fields=[
                ('category_id', models.CharField(max_length=64, verbose_name='ID категории в сторонней системе')),
                ('title', models.CharField(max_length=128, verbose_name='Имя категории')),
                ('icon_s3_key', models.TextField(blank=True, default='', verbose_name='Key S3 иконки')),
                ('rank', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1)], verbose_name='Целое число для задания порядка элементов(чтобы можно было посортировать)')),
                ('position', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1)], verbose_name='Целое число для задания абсолютной позиции в выдаче, куда встраивается категория')),
                ('thumbnail_s3_key', models.TextField(blank=True, null=True, verbose_name='Ключ S3 превью')),
                ('logo_s3_key', models.TextField(blank=True, default='', verbose_name='Ключ S3 логотипа')),
                ('banner_S3_key', models.TextField(blank=True, default='', verbose_name='Key S3 баннера')),
                ('description', models.TextField(blank=True, default='', verbose_name='Описание категории')),
                ('content_type', models.TextField(blank=True, choices=[('', 'VH category item'), ('vh_carousel', 'VH carousel'), ('external_kp', 'Kinopoisk carousel'), ('external_category_kp', 'Kinopoisk category'), ('embedded_section', 'Embedded section')], default='', verbose_name='Тип категории')),
                ('id', models.IntegerField(primary_key=True, serialize=False, verbose_name='Внутренний ID категории')),
                ('above_platforms', models.ManyToManyField(related_name='proxy_category2_above_platforms', related_query_name='proxy_category2s_above', to='proxy.PlatformModel')),
                ('below_platforms', models.ManyToManyField(related_name='proxy_category2_below_platforms', related_query_name='proxy_category2s_below', to='proxy.PlatformModel')),
                ('exclude_platforms', models.ManyToManyField(related_name='proxy_category2_exclude_platforms', related_query_name='proxy_category2s_exclude', to='proxy.PlatformModel')),
                ('include_platforms', models.ManyToManyField(related_name='proxy_category2_include_platforms', related_query_name='proxy_category2s_include', to='proxy.PlatformModel')),
                ('parent_category', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='proxy.Category2')),
            ],
            options={
                'verbose_name_plural': 'Published categories',
                'ordering': ('position', 'rank'),
            },
        ),
        migrations.RunPython(
            code=copy_categories,
            reverse_code=revert_copying_categories
        ),
        migrations.RunPython(
            code=copy_parent_category_ids,
            reverse_code=erase_parent_category_for_new_model
        ),
        migrations.RunPython(
            code=copy_platforms,
            reverse_code=erase_platforms
        ),
    ]
