# Generated by Django 2.2.24 on 2021-06-27 10:18

from django.db import migrations, models
from django.db.migrations.operations.special import RunPython


def fill_recommended_channels(apps, schema_editor):
    RecommendedChannel = apps.get_model('proxy', 'RecommendedChannel')

    db_alias = schema_editor.connection.alias
    RecommendedChannel.objects.using(db_alias).bulk_create([
        RecommendedChannel(title='Звезда', channel_id=405, rank=10),
        RecommendedChannel(title='RU TV', channel_id=258, rank=20),
        RecommendedChannel(title='МУЗ-ТВ', channel_id=897, rank=30),
        RecommendedChannel(title='Ю', channel_id=898, rank=40),
        RecommendedChannel(title='Советское кино', channel_id=1894, rank=50),
        RecommendedChannel(title='Охотник и Рыболов Int', channel_id=1778, rank=60),
        RecommendedChannel(title='Диалоги о рыбалке', channel_id=1979, rank=70),
        RecommendedChannel(title='360', channel_id=161, rank=80),
        RecommendedChannel(title='Europa Plus TV', channel_id=681, rank=90),
        RecommendedChannel(title='Москва-24', channel_id=334, rank=100),
        RecommendedChannel(title='Классика Кино', channel_id=1790, rank=110),
        RecommendedChannel(title='Мир Сериала', channel_id=145, rank=120),
        RecommendedChannel(title='ТНТ Music', channel_id=680, rank=130),
        RecommendedChannel(title='Советские мультфильмы', channel_id=1895, rank=140),
        RecommendedChannel(title='360 Новости', channel_id=1856, rank=150),
        RecommendedChannel(title='Russian MusicBox', channel_id=25, rank=160),
        RecommendedChannel(title='МИР 24', channel_id=1331, rank=170),
        RecommendedChannel(title='Любимое.ТВ', channel_id=1803, rank=180),
        RecommendedChannel(title='МИР', channel_id=726, rank=190),
        RecommendedChannel(title='Евроновости', channel_id=23, rank=200),
    ])


class Migration(migrations.Migration):

    dependencies = [
        ('proxy', '0036_auto_20210701_1621'),
    ]

    operations = [
        migrations.CreateModel(
            name='RecommendedChannel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=64, verbose_name='Название (видит только админ)')),
                ('channel_id', models.IntegerField(verbose_name='ID канала в VH')),
                ('rank', models.IntegerField(default=0, verbose_name='Ключ сортировки')),
                ('visible', models.BooleanField(default=True)),
            ],
        ),
        RunPython(
            code=fill_recommended_channels,
            reverse_code=RunPython.noop
        ),
    ]
