# Generated by Django 2.2.24 on 2021-12-07 12:12

from django.db import migrations, models
from django.db.migrations.operations.special import RunPython

CHANNELS_EXCEL = """
1001	Первый канал	52d555c99109550984000004	#103775	/get-dialogs/1017510/first/orig	200401	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL3BlcnZpeS5wbmc=
1002	Россия 1	52d555c9910955098400000d	#AF2418	/get-dialogs/1676983/russia1/orig	200402	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL3Jvc3NpYTEucG5n
1003	Матч!	535f5da5ebf8c403a1001bd9	#B68B44	/get-dialogs/4755732/match/orig	200403	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL21hdGNodHZfbmV3LnBuZw==
1004	НТВ	535f7ecaebf8c403a10050b9	#56A03E	/get-dialogs/1027858/ntv/orig	200404	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL250di5wbmc=
1005	Пятый канал	52d555c9910955098400000c	#BE282E	/get-dialogs/1530877/5channel/orig	200405	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzLzVfY2hhbm5lbC5wbmc=
1006	Россия К	535f7d96ebf8c403a10050b0	#CA352D	/get-dialogs/1676983/culture/orig	200406	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL3Jvc3NpYWsucG5n
1007	Россия 24	53f3067e4e2e670103007d77	#AB2317	/get-dialogs/4755732/russia24/orig	200407	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL3Jvc3NpYTI0LnBuZw==
1008	Карусель	535f806bebf8c403a10050c6	#5CD2FA	/get-dialogs/1530877/carousel/orig	200408	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL2thcnVzZWwucG5n
1009	ОТР	535f7c43ebf8c403a10050a6	#D24F90	/get-dialogs/1017510/otr/orig	200409	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL290ci5wbmc=
1010	ТВ Центр	535f5fdeebf8c403a1001beb	#D53630	/get-dialogs/998463/tvcenter/orig	200410	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL3R2Y2VudGVyLnBuZw==
1011	РЕН ТВ	53f309064e2e670103007d7c	#EA9836	/get-dialogs/998463/rentv/orig	200411	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL3JlbnR2LnBuZw==
1012	Спас	53f5d2c64e2e671f2b000001	#3372B8	/get-dialogs/4755732/spas/orig	200412	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL3NwYXNfMDFfMDNfMTgucG5n
1013	СТС	53f308a64e2e670103007d7b	#f4ce6a	/get-dialogs/1676983/sts/orig	200413	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL2N0Y19uZXdfMjQxMC5wbmc=
1014	Домашний	53f3081a4e2e670103007d7a	#B52F51	/get-dialogs/4755732/domashny/orig	200414	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL2RvbWFzaG5peV8wOTE4LnBuZw==
1015	ТВ3	53f30f034e2e670103007d86	#672A79	/get-dialogs/4755732/tv3/orig	200415	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL3R2M19uZXcucG5n
1016	Пятница!	53f30cf24e2e670103007d83	#D43630	/get-dialogs/4755732/friday/orig	200416	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL3B5YXRuaXRzYS5wbmc=
1017	Звезда	53f30a7f4e2e670103007d7e	#A92216	/get-dialogs/4755732/zvezda/orig	200417	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL3p2ZXpkYS5wbmc=
1018	МИР	535f8014ebf8c403a10050c3	#94BA56	/get-dialogs/1017510/mir/orig	200418	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL21pci5wbmc=
1019	ТНТ	53f30c5b4e2e670103007d82	#459DE3	/get-dialogs/399212/tnt/orig	200419	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL3RudF9uZXcucG5n
1020	Муз-ТВ	54726a1d4e2e675987006a4b	#D33F92	/get-dialogs/4755732/muztv/orig	200420	http://img.smotreshka.tv/image/aHR0cDovL2ltZy5iNjEyLnRpZ2h0dmlkZW8uY29tL2NoYW5uZWxzL211enR2XzEwMjEucG5n
"""


def fill_smotreshka_channels(apps, schema_editor):
    SmotreshkaChannel = apps.get_model('proxy', 'SmotreshkaChannel')

    channels = []
    for line in CHANNELS_EXCEL.split('\n'):
        if not line.strip():
            continue
        num, title, id, color, icon, vh_id, thumb = line.split('\t')
        ch = SmotreshkaChannel(
            title=title,
            smotreshka_channel_id=id,
            number=num,
            main_color=color.upper(),
            smarttv_icon=f'https://avatars.mds.yandex.net/{icon}',
            channel_id=vh_id,
            category='federal',
            thumbnail=thumb,
        )
        channels.append(ch)

    db_alias = schema_editor.connection.alias
    SmotreshkaChannel.objects.using(db_alias).bulk_create(channels)


class Migration(migrations.Migration):

    dependencies = [
        ('proxy', '0040_auto_20211007_1207'),
    ]

    operations = [
        migrations.CreateModel(
            name='SmotreshkaChannel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='Название')),
                ('enabled', models.BooleanField(default=False, verbose_name='Включен')),
                ('smotreshka_channel_id', models.CharField(max_length=100, verbose_name='ID канала в смотрешке')),
                ('channel_id', models.PositiveIntegerField(verbose_name='ID канала (как в вх)')),
                ('category', models.CharField(choices=[('inform', 'Новостные'), ('films', 'Кино и сериалы'), ('educate', 'Познавательные'), ('child', 'Детские'), ('entertain', 'Развлекательные'), ('music', 'Музыкальные'), ('sport', 'Спортивные'), ('federal', 'Федеральные'), ('foreign', 'Международные'), ('region', 'Региональные')], max_length=64, verbose_name='Категория')),
                ('number', models.PositiveIntegerField(verbose_name='Номер')),
                ('main_color', models.CharField(blank=True, max_length=10, verbose_name='Цвет заливки иконки')),
                ('thumbnail', models.CharField(blank=True, max_length=500, verbose_name='Картинка для карточки')),
                ('smarttv_icon', models.CharField(blank=True, max_length=500, verbose_name='Иконка')),
            ],
        ),
        RunPython(
            code=fill_smotreshka_channels,
            reverse_code=RunPython.noop
        ),
    ]
