# Generated by Django 2.2.27 on 2022-03-31 14:15

from django.db import migrations, models
from django.db.migrations.operations.special import RunPython


def fill_cinemas(apps, schema_editor):
    Cinema = apps.get_model('proxy', 'Cinema')

    db_alias = schema_editor.connection.alias
    Cinema.objects.using(db_alias).bulk_create([
        Cinema(code='wink', enabled=False),
        Cinema(code='okko', enabled=False),
        Cinema(code='megafon', enabled=False),
        Cinema(code='kp', enabled=False),
        Cinema(code='kion', enabled=False),
        Cinema(code='ivi', enabled=False),
        Cinema(code='appletv', enabled=False),
        Cinema(code='1tv', enabled=False),
    ])


class Migration(migrations.Migration):

    dependencies = [
        ('proxy', '0044_promo_enabled'),
    ]

    operations = [
        migrations.CreateModel(
            name='Cinema',
            fields=[
                ('code', models.CharField(max_length=255, primary_key=True, serialize=False, verbose_name='Код')),
                ('enabled', models.BooleanField(default=False, verbose_name='Включен')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Создан', null=True)),
            ],
        ),
        RunPython(
            code=fill_cinemas,
            reverse_code=RunPython.noop
        ),
    ]
