from enum import Enum
from typing import Iterable

from smarttv.droideka.proxy.constants.carousels import VhFeed


def copy_field_if_presented(src: dict, dst: dict, field_name: str):
    if field_name in src:
        dst[field_name] = src[field_name]


def copy_fields_if_presented(src: dict, dst: dict, fields: Iterable):
    for field in fields:
        copy_field_if_presented(src=src, dst=dst, field_name=field)


class VhFeedResponse:
    FIELD_USER_DATA = 'user_data'
    FIELD_REQID = 'reqid'
    FIELD_APPHOST_REQID = 'apphost-reqid'

    FIELDS_TO_COPY = (FIELD_USER_DATA, FIELD_REQID, FIELD_APPHOST_REQID)

    ITEMS_DEFAULT_RESULT = tuple()

    def __init__(self, vh_raw_response: dict):
        self.tracking_params = {}
        if vh_raw_response:
            copy_fields_if_presented(
                src=vh_raw_response,
                dst=self.tracking_params,
                fields=self.FIELDS_TO_COPY
            )
        self.cache_hash = vh_raw_response.get(VhFeed.FIELD_CACHE_HASH)
        self.carousels = vh_raw_response.get('items', self.ITEMS_DEFAULT_RESULT)

    @property
    def carousels_size(self) -> int:
        return len(self.carousels)


class MixedCarouselsResponse:
    KEY_FEED = 'feed'
    KEY_INJECTABLE_CAROUSELS = 'key_injectable_carousels'

    def __init__(self, feed, injectable_carousels, more_url):
        self.feed = feed
        self.injectable_carousels = injectable_carousels
        self.more_url = more_url


class KpMultiSelectionsResponseFields:
    TYPE_MULTI_SELECTION = 'MULTISELECTION'
    TYPE_SELECTION = 'SELECTION'
    TYPE_FEATURE = 'FEATURE'
    TYPE_PROMO = 'PROMO'

    # плоcкие типы, означает что карусели с такими типами могут иметь только документы
    # или другими cловами - не могут иметь внутри фичеры
    FLAT_TYPES = (TYPE_SELECTION, TYPE_SELECTION, TYPE_PROMO)

    FIELD_DATA = 'data'
    FIELD_TO = 'to'
    FIELD_IMAGE_URL = 'imageUrl'
    FIELD_SELECTION_ID = 'selectionId'
    FIELD_COLLECTIONS = 'collections'
    FIELD_TYPE = 'type'
    FIELD_CAROUSEL_TYPE = 'carousel_type'
    FIELD_CONTENT_TYPE = 'contentType'
    FIELD_TITLE = 'title'

    class OttContentType(Enum):
        SERIES = 'tv-series'
        MOVIE = 'ott-movie'
        CHANNEL = 'channel'
        SELECTION = 'SELECTION'
        UNKNOWN = 'unknown'

        @staticmethod
        def value_of(raw_value: str) -> 'KpMultiSelectionsResponseFields.OttContentType':
            try:
                return KpMultiSelectionsResponseFields.OttContentType(raw_value)
            except ValueError:
                return KpMultiSelectionsResponseFields.OttContentType.UNKNOWN
