from copy import deepcopy
from drf_yasg import openapi
from rest_framework import status

from smarttv.droideka.proxy.api import vh, es
from smarttv.droideka.proxy.swagger import episode_spec


rating_item_schema = openapi.Schema(
    description='Информация о рейтинге',
    type=openapi.TYPE_OBJECT,
    properties={
        'rating_count': openapi.Schema(type=openapi.TYPE_INTEGER),
        'original_rating_value': openapi.Schema(type=openapi.TYPE_INTEGER),
        'rating_value': openapi.Schema(type=openapi.TYPE_NUMBER),
        'best_rating': openapi.Schema(type=openapi.TYPE_NUMBER),
        'url': openapi.Schema(type=openapi.TYPE_STRING),
        'name': openapi.Schema(type=openapi.TYPE_STRING),
        'type': openapi.Schema(type=openapi.TYPE_STRING),
        'original_best_rating': openapi.Schema(type=openapi.TYPE_INTEGER),
    })
ratings_schema = openapi.Schema(
    description='Рейтинги на различных рейтинговых сайтах',
    type=openapi.TYPE_ARRAY,
    items=rating_item_schema)
trailer_schema = openapi.Schema(
    description='Информация о трейлере', type=openapi.TYPE_OBJECT,
    properties={
        'stream_url': openapi.Schema(
            'URL для проигрывания трейлера',
            type=openapi.TYPE_STRING
        ),
        'date': openapi.Schema(type=openapi.TYPE_STRING),
        'vh_uuid': openapi.Schema(type=openapi.TYPE_STRING),
        'url': openapi.Schema(type=openapi.TYPE_STRING),
        'external': openapi.Schema(type=openapi.TYPE_INTEGER),
        'duration': openapi.Schema(type=openapi.TYPE_INTEGER),
        'thumbnail': openapi.Schema(
            type=openapi.TYPE_OBJECT,
            properties={
                'thmb_href': openapi.Schema(type=openapi.TYPE_STRING),
                'thmb_h_orig': openapi.Schema(type=openapi.TYPE_INTEGER),
                'thmb_w_orig': openapi.Schema(type=openapi.TYPE_INTEGER),
            }),
    })


def get_card_detail_info():
    result = deepcopy(episode_spec.base_episode_properties)
    result['actors'] = openapi.Schema(description='Список актеров', type=openapi.TYPE_STRING),
    result['directors'] = openapi.Schema(description='Режиссеры', type=openapi.TYPE_STRING),
    result['logo'] = openapi.Schema(description='Кинопоисковый логотип', type=openapi.TYPE_STRING),
    result['cover'] = openapi.Schema(description='Кинопоисковая обложка', type=openapi.TYPE_STRING),
    result['trailer'] = trailer_schema,
    result['ratings'] = ratings_schema
    return result


def get_card_detail_request_params():
    card_detail_params = [
        openapi.Parameter(
            name='content_id',
            in_=openapi.IN_QUERY,
            description='Id документа VH(видео хостинг)',
            type=openapi.TYPE_STRING,
            required=True
        ),
        openapi.Parameter(
            name='onto_id',
            in_=openapi.IN_QUERY,
            description="Id документа ОО(объектного ответа)",
            type=openapi.TYPE_STRING,
            required=False
        ),
        openapi.Parameter(
            name='content_type',
            in_=openapi.IN_QUERY,
            description="Тип документа. Обязателен, если есть или, если передан 'onto_id'",
            type=openapi.TYPE_STRING,
            required=False,
            enum=vh.VH_CONTENT_TYPES + es.OO_CONTENT_TYPES
        )
    ]
    return card_detail_params


class FullCardDetailSpec:
    season_episode_schema = openapi.Schema(
        description='Информация об эпизоде',
        type=openapi.TYPE_OBJECT,
        properties={
            'thumbnail': openapi.Schema(type=openapi.TYPE_STRING),
            'content_type': openapi.Schema(type=openapi.TYPE_STRING, enum=vh.VH_CONTENT_TYPES),
            'player_id': openapi.Schema(type=openapi.TYPE_STRING),
            'title': openapi.Schema(type=openapi.TYPE_STRING),
            'content_id': openapi.Schema(type=openapi.TYPE_STRING),
            'duration_s': openapi.Schema(type=openapi.TYPE_INTEGER),
            'season_number': openapi.Schema(type=openapi.TYPE_INTEGER),
            'episode_number': openapi.Schema(type=openapi.TYPE_INTEGER),
        },
        required=['content_id', 'title', 'duration_s', 'content_id', 'season_number', 'episode_number', 'player_id']
    )
    season_schema = openapi.Schema(
        description='Информация о сезоне',
        type=openapi.TYPE_OBJECT,
        properties={
            'type': openapi.Schema(type=openapi.TYPE_STRING),
            'episodes_count': openapi.Schema(type=openapi.TYPE_INTEGER),
            'season_number': openapi.Schema(type=openapi.TYPE_INTEGER),
            'episodes': openapi.Schema(type=openapi.TYPE_ARRAY, items=season_episode_schema),
        },
    )
    response_schema = {
        status.HTTP_200_OK: openapi.Schema(type=openapi.TYPE_OBJECT, properties={
            'content_id': episode_spec.content_id_schema,
            'title': episode_spec.title_schema,
            'description': episode_spec.description_schema,
            'content_type': episode_spec.content_type,
            'onto_category': episode_spec.onto_category_schema,
            'thumbnail': episode_spec.thumbnail,
            'percentage_score': episode_spec.percentage_score,
            'release_year': episode_spec.release_year,
            'restriction_age': episode_spec.restriction_age,
            'genres': episode_spec.genres_schema,
            'actors': openapi.Schema(description='Список актеров', type=openapi.TYPE_STRING),
            'countries': openapi.Schema(description='Список стран', type=openapi.TYPE_STRING),
            'directors': openapi.Schema(description='Режиссеры', type=openapi.TYPE_STRING),
            'logo': openapi.Schema(description='Кинопоисковый логотип', type=openapi.TYPE_STRING),
            'cover': openapi.Schema(description='Кинопоисковая обложка', type=openapi.TYPE_STRING),
            'player_id': episode_spec.player_id_schema,
            'ya_plus': episode_spec.ya_plus_schema,
            'trailer': trailer_schema,
            'seasons': season_schema,
            'ratings': ratings_schema
        }),
        status.HTTP_404_NOT_FOUND: openapi.Schema(type=openapi.TYPE_OBJECT, properties={
            'detail': openapi.Schema(description='Сообщение об ошибке', type=openapi.TYPE_STRING)
        })

    }

    @classmethod
    def get_request_params(cls):
        return get_card_detail_request_params()


FullCardDetailV6Spec = dict(
    operation_description='API информации о фильме',
    operation_summary='API информации о фильме',
    responses={
        status.HTTP_200_OK: openapi.Schema(type=openapi.TYPE_OBJECT,
                                           properties=get_card_detail_info()),
        status.HTTP_404_NOT_FOUND: openapi.Schema(type=openapi.TYPE_OBJECT, properties={
            'detail': openapi.Schema(description='Сообщение об ошибке', type=openapi.TYPE_STRING)
        })
    },
    manual_parameters=get_card_detail_request_params(),
)

ThinCardDetailSpec = dict(
    operation_description='Легковесная ручка для плеера',
    operation_summary='Легковесная ручка для плеера',
    responses={
        status.HTTP_200_OK: openapi.Schema(type=openapi.TYPE_OBJECT, properties={
            'title': episode_spec.title_schema,
            'content_type': episode_spec.content_type,
            'release_year': episode_spec.release_year,
            'restriction_age': episode_spec.restriction_age,
            'genres': episode_spec.genres_schema,
            'player_id': episode_spec.player_id_schema,
        })
    },
    manual_parameters=[
        openapi.Parameter(
            name='content_id',
            in_=openapi.IN_QUERY,
            description='Id документа VH',
            type=openapi.TYPE_STRING,
            required=True
        )
    ]
)

RatingsCardDetailSpec = dict(
    operation_description='Информация о рейтингах фильма для кинопоисковой карточки. Используетс в либе КП',
    operation_summary='Информация о рейтингах фильма',
    responses={
        status.HTTP_200_OK: openapi.Schema(type=openapi.TYPE_OBJECT, properties={
            'percentage_score': episode_spec.percentage_score,
            'ratings': ratings_schema
        })
    },
    manual_parameters=[
        openapi.Parameter(
            name='content_id',
            in_=openapi.IN_QUERY,
            description='Id документа VH',
            type=openapi.TYPE_STRING,
            required=True
        )
    ]
)

ProgressCardDetailSpec = dict(
    operation_description='Информация о просмотре фильма пользователем',
    operation_summary='Информация о просмотре фильма',
    responses={
        status.HTTP_200_OK: openapi.Schema(type=openapi.TYPE_OBJECT, properties={
            'duration': openapi.Schema(type=openapi.TYPE_INTEGER),
            'progress': openapi.Schema(type=openapi.TYPE_INTEGER),
        })
    },
    manual_parameters=[
        openapi.Parameter(
            name='content_id',
            in_=openapi.IN_QUERY,
            description='Id документа VH',
            type=openapi.TYPE_STRING,
            required=True
        )
    ]
)
