import copy

from drf_yasg import openapi
from rest_framework import status

from smarttv.droideka.proxy import exceptions, api
from smarttv.droideka.proxy.serializers import serializers
from smarttv.droideka.proxy.swagger.base import PlatformParamsSchemaProvider, KidModeParamsSchemaProvider, PaginationParamSchemaProvider


document_schema = openapi.Schema(
    type=openapi.TYPE_OBJECT,
    description='Документ выдачи',
)

rvb_mapping_schema = openapi.Schema(
    type=openapi.TYPE_OBJECT,
    description='Соответствие content_id -> rvb',
)

includes_schema = openapi.Schema(
    type=openapi.TYPE_ARRAY,
    description='Документы выдачи',
    items=document_schema,
)

long_content_schema = openapi.Schema(
    type=openapi.TYPE_ARRAY,
    description='Длинный контент: фильмы, сериалы и анимация',
    items=document_schema,
)

videos_schema = openapi.Schema(
    type=openapi.TYPE_ARRAY,
    description='Видео',
    items=document_schema,
)


BaseDoc2DocSpec = dict(
    query_serializer=serializers.Doc2DocRequestValidator,
    manual_parameters=PlatformParamsSchemaProvider.get() + PaginationParamSchemaProvider.get() + KidModeParamsSchemaProvider.get(),
    operation_description='Проксирующая ручка doc2doc видеохостинга',
    operation_summary='Проксирующая ручка doc2doc видеохостинга',
    responses={
        status.HTTP_400_BAD_REQUEST: openapi.Response('Ошибка валидации. Подробности указаны в ответе сервера'),
        status.HTTP_404_NOT_FOUND: openapi.Response('Документ не найден'),
        exceptions.InternalServerError.status_code: openapi.Response('Внутренняя ошибка сервера'),
        api.vh.FrontendVHApi.BadGatewayError.status_code: openapi.Response('Ошибка на стороне Видеохостинга, подробности в ответе'),
    },
)


def get_spec_with_properties(**properties):
    spec = copy.deepcopy(BaseDoc2DocSpec)
    spec['responses'][status.HTTP_200_OK] = openapi.Schema(
        description='JSON с ответом Видеохостинга',
        type=openapi.TYPE_OBJECT,
        properties=properties,
    )
    return spec


Doc2DocV4Spec = get_spec_with_properties(
    rvb_mapping=rvb_mapping_schema,
    includes=includes_schema,
)


Doc2DocV6Spec = get_spec_with_properties(
    rvb_mapping=rvb_mapping_schema,
    long_content=long_content_schema,
    videos=videos_schema,
)
