from copy import deepcopy
from drf_yasg import openapi

from smarttv.droideka.proxy.api import vh
from smarttv.droideka.proxy.player_detection import PlayerDetector
from smarttv.droideka.proxy.models import Category2

OWNED_INFO_EXAMPLE = """
```
\t{
\t\t"AVOD": true
\t}
```
или
```
\t{
\t\t"TVOD": true
\t}
```
или
```
\t{
\t\t"EST": true
\t}
```
или
```
\t{
\t\t"SVOD": true
\t}
```\n
"""

percentage_score = openapi.Schema(
    description='Релевантность документа (персонализирована)',
    type=openapi.TYPE_INTEGER)
title_schema = openapi.Schema(description='Заголовок', type=openapi.TYPE_STRING)
player_id_schema = openapi.Schema(
    description='ID плеера, в котором надо открывать документ',
    type=openapi.TYPE_STRING,
    enum=[PlayerDetector.VH_PLAYER,
          PlayerDetector.OTT_PLAYER,
          PlayerDetector.KINOPOISK_PLAYER,
          PlayerDetector.WEB_VIEW_PLAYER])
genres_schema = openapi.Schema(description='Список жанров', type=openapi.TYPE_STRING)
restriction_age = openapi.Schema(description='Ограничения по возрасту', type=openapi.TYPE_INTEGER)
release_year = openapi.Schema(description='Год выпуска', type=openapi.TYPE_INTEGER)
content_type = openapi.Schema(
    description='Тип документа в VH', type=openapi.TYPE_STRING,
    enum=vh.VH_CONTENT_TYPES)
content_id_schema = openapi.Schema(description='Id документа VH', type=openapi.TYPE_STRING)
description_schema = openapi.Schema(description='Описание', type=openapi.TYPE_STRING)
onto_category_schema = openapi.Schema(description='Тип документа в ОО', type=openapi.TYPE_STRING,
                                      enum=['series', 'anim_series', 'film', 'anim_film'])
thumbnail = openapi.Schema(type=openapi.TYPE_STRING)
ya_plus_schema = openapi.Schema(description='Информация о подписке. Поле deprecated и поддерживается только для старых '
                                            'клиентов. Использовать его для новых клиентов - нельзя',
                                type=openapi.TYPE_ARRAY, items=openapi.Schema(type=openapi.TYPE_STRING),
                                deprecated=True)
countries_scheme = openapi.Schema(description='Список стран', type=openapi.TYPE_STRING)
owned_scheme = openapi.Schema(
    description='Информация о владении пользователем. Всего 4 модели монетизации: AVOD, TVOD, SVOD, EST.\n'
                'Данный словарь содержит информацию о доступности для пользователя по ссоответствующей модели '
                'монетизации.\n'
                'Если контент лицензионный - гарантируется что это поле присутствует и что у его в словаре есть хотя бы'
                'одна модель монетизации. Для не лицензионного контента - поле не приходит.\n'
                'Если внутри словаря не присутствует какая-то модель монетизации - считать что значение для нее - '
                '`false`. Словарь имеeт следующий внешний вид:'
                f'{OWNED_INFO_EXAMPLE}'
                'В будущем, возможно будут приходить сразу несколько флагов. Пока - только 1',
    type=openapi.TYPE_OBJECT,
    properties={
        'AVOD': openapi.Schema(description='доступен с просмотром рекламы', type=openapi.TYPE_BOOLEAN),
        'TVOD': openapi.Schema(description='пользователь арендовал документ и в данный момент доступен '
                                           'просмотр по аренде', type=openapi.TYPE_BOOLEAN),
        'EST': openapi.Schema(description='пользователь купил документ', type=openapi.TYPE_BOOLEAN),
        'SVOD': openapi.Schema(description='в данный момент доступен пользователю по подписке',
                               type=openapi.TYPE_BOOLEAN),
    })

base_episode_properties = {
    'content_id': content_id_schema,
    'title': title_schema,
    'description': description_schema,
    'content_type': content_type,
    'onto_category': onto_category_schema,
    'thumbnail': thumbnail,
    'percentage_score': percentage_score,
    'release_year': release_year,
    'restriction_age': restriction_age,
    'genres': genres_schema,
    'countries': countries_scheme,
    'player_id': player_id_schema,
    'ya_plus': ya_plus_schema,
    'owned': owned_scheme,
}


def get_carousel_episode_properties():
    result = deepcopy(base_episode_properties)
    carousel_episode_content_type_spec = openapi.Schema(
        description='Тип документа в VH', type=openapi.TYPE_STRING,
        enum=vh.VH_CONTENT_TYPES + (Category2.EMBEDDED_CAROUSEL_TYPE, Category2.EMBEDDED_CATEGORY_TYPE))
    result['content_type'] = carousel_episode_content_type_spec
    return result
