from drf_yasg import openapi
from rest_framework import status

from smarttv.droideka.proxy.serializers import serializers
from smarttv.droideka.proxy.serializers.fast_response import ProgramsSerializer
from smarttv.droideka.proxy.swagger.base import PlatformParamsSchemaProvider
from smarttv.droideka.proxy.views.base import BackendAPIException

ProgramsSpec = dict(
    operation_description='API програм передач',
    operation_summary='API програм передач',
    responses={
        status.HTTP_200_OK: openapi.Response(
            'Список програм для запрошенных каналов',
            openapi.Schema(type=openapi.TYPE_OBJECT, properties={
                ProgramsSerializer.START_TIME: openapi.Schema(
                    description='Время начала программы', type=openapi.TYPE_STRING),
                ProgramsSerializer.END_TIME: openapi.Schema(
                    description='Время конца программы', type=openapi.TYPE_STRING),
                ProgramsSerializer.PROGRAM_ID: openapi.Schema(
                    description='Идентификатор программы', type=openapi.TYPE_STRING),
                ProgramsSerializer.HAS_CACHUP: openapi.Schema(
                    description='Имеется ли запись программы', type=openapi.TYPE_STRING),
                ProgramsSerializer.HAS_SCHEDULE: openapi.Schema(type=openapi.TYPE_STRING),
                ProgramsSerializer.PROGRAM_TITLE: openapi.Schema(type=openapi.TYPE_STRING),
                ProgramsSerializer.TITLE: openapi.Schema(type=openapi.TYPE_STRING),
                ProgramsSerializer.LIVE_STREAM: openapi.Schema(type=openapi.TYPE_STRING),
                ProgramsSerializer.COMBINED_TITLE: openapi.Schema(type=openapi.TYPE_STRING),
            }, required=ProgramsSerializer.get_required_fields()),
        ),
        BackendAPIException.status_code: openapi.Response(
            'Ошибка валидации результата с сервера: некорректные данные от VH или VH недоступен. '
            'Может возникать при попытке получить неактуальное расписание. '
            'Для обхода проблемы нужно запросить актуальный список каналов.',
        ),
    },
    query_serializer=serializers.ProgramsValidator,
    manual_parameters=PlatformParamsSchemaProvider.get(),
)
