from drf_yasg import openapi
from rest_framework import status

from smarttv.droideka.proxy.swagger.base import PlatformParamsSchemaProvider
from smarttv.droideka.proxy.serializers.serializers import ScreenSaverValidator

screen_saver_type_schema = openapi.Parameter(
    name='type',
    in_=openapi.IN_QUERY,
    description='Тип скринсейверов',
    type=openapi.TYPE_STRING,
    required=True,
    enum=['image', 'video']
)

screen_saver_url_schema = openapi.Schema(type=openapi.TYPE_OBJECT, properties={
    'url': openapi.Schema(description='URL для скачивания сринсейвера', type=openapi.TYPE_STRING),
}, required=['url'])


class ScreenSaverSpec:
    response_schema = {
        status.HTTP_200_OK: openapi.Schema(type=openapi.TYPE_OBJECT, properties={
            'type': screen_saver_type_schema,
            'media': openapi.Schema(description='Список скринсейверов',
                                    type=openapi.TYPE_ARRAY,
                                    items=screen_saver_url_schema)
        })
    }

    @classmethod
    def get_request_params(cls):
        params = PlatformParamsSchemaProvider.get()
        params.extend([
            openapi.Parameter(
                name='offset',
                in_=openapi.IN_QUERY,
                description='Как много элементов нужно пропустить(смещение относительно начала списка).',
                type=openapi.TYPE_INTEGER,
                required=False
            ),
            openapi.Parameter(
                name='limit',
                in_=openapi.IN_QUERY,
                description='Сколько элементов получить в выдаче.'
                            f'Максимальный лимит - {ScreenSaverValidator.SCREEN_SAVER_MAX_LIMIT}, '
                            f'дефолтный лимит - {ScreenSaverValidator.SCREEN_SAVER_DEFAULT_LIMIT}',
                type=openapi.TYPE_INTEGER,
                required=False
            )])
        params.extend([
            screen_saver_type_schema,
            openapi.Parameter(
                name='resolution',
                in_=openapi.IN_QUERY,
                description="Разрешение, на которое нужно отдать этот скринсейвер",
                type=openapi.TYPE_STRING,
                required=True,
                enum=['HD', 'FHD', 'QHD']
            )
        ])
        return params
