from drf_yasg import openapi
from rest_framework import status

from smarttv.droideka.proxy import exceptions, api
from smarttv.droideka.proxy.serializers import serializers
from smarttv.droideka.proxy.swagger.base import PlatformParamsSchemaProvider


SearchSpec = dict(
    query_serializer=serializers.SearchValidator,
    manual_parameters=PlatformParamsSchemaProvider.get(),
    operation_description='Проксирующая ручка для поиска по видео',
    operation_summary='Проксирующая ручка для поиска по видео',
    responses={
        status.HTTP_200_OK: openapi.Response('JSON с результатами поиска'),
        status.HTTP_400_BAD_REQUEST: openapi.Response('Ошибка валидации. Подробности указаны в ответе сервера'),
        exceptions.InternalServerError.status_code: openapi.Response('Внутренняя ошибка сервера'),
        api.vs.VideoSearchApi.BadGatewayError.status_code: openapi.Response('Ошибка на стороне Видеопоиска, подробности в ответе'),
    },
)


SuggestHistorySpec = dict(
    query_serializer=serializers.SuggestHistoryValidator,
    manual_parameters=PlatformParamsSchemaProvider.get(),
    operation_description='Ручка для сохранения истории поиска по видео',
    operation_summary='Ручка для сохранения истории поиска по видео',
)
