from drf_yasg import openapi
from rest_framework import status
from smarttv.droideka.proxy.serializers import serializers

from smarttv.droideka.proxy.api import vh
from smarttv.droideka.proxy.swagger.base import PlatformParamsSchemaProvider
from smarttv.droideka.proxy.swagger import episode_spec

episode_schema_properties = {
    'content_id': openapi.Schema(description='Id эпизода VH', type=openapi.TYPE_STRING),
    'title': openapi.Schema(
        description='Заголовок эпизода.\n'
                    'Если у эпизода есть имя - вернется в формате "<номер эпизода>. <имя эпизода>".'
                    'Например "1. Зима близко"\n'
                    'Если у эпизода нету имени - в формате "Эпизод <номер эпизода>."'
                    'Например "Эпизод 1"',
        type=openapi.TYPE_STRING
    ),
    'content_type': openapi.Schema(
        description='Тип документа в VH\n'
                    'Конкретно здесь всегда должен быть "vod-episode"',
        type=openapi.TYPE_STRING,
        enum=[vh.CONTENT_TYPE_EPISODE]
    ),
    'duration_s': openapi.Schema(
        type=openapi.TYPE_INTEGER,
        description='Длительность эпизода'
    ),
    'thumbnail': openapi.Schema(type=openapi.TYPE_STRING),
    'player_id': episode_spec.player_id_schema,
    'episode_number': openapi.Schema(
        type=openapi.TYPE_INTEGER,
        description='Номер эпизода'
    ),
    'season_number': openapi.Schema(
        type=openapi.TYPE_INTEGER,
        description='Номер сезона'
    ),
    'restriction_age': openapi.Schema(
        type=openapi.TYPE_INTEGER,
        description='Оганичение по возрасту'
    ),
}

episode_schema = openapi.Schema(
    type=openapi.TYPE_OBJECT,
    properties=episode_schema_properties)

season_schema = openapi.Schema(
    type=openapi.TYPE_OBJECT,
    properties={
        'season_number': openapi.Schema(
            type=openapi.TYPE_INTEGER,
            description='Номер сезона'
        ),
        "episodes_count": openapi.Schema(
            type=openapi.TYPE_INTEGER,
            description='Количество эпизодов в этом сезоне'
        ),
        'type': openapi.Schema(type=openapi.TYPE_STRING),
        'season_id': openapi.Schema(
            description='Id сезона VH\n'
                        'Должен быть использован для получения эпизодов для данного сезона',
            type=openapi.TYPE_STRING
        ),
        'episodes': openapi.Schema(type=openapi.TYPE_ARRAY, items=episode_schema)
    },
    description='Возвращается информация о сезоне + если доступна - то первая серия этого сезона'
)

SeasonsSpec = dict(
    operation_description='API получения сезонов сериала',
    operation_summary='API получения сезонов сериала',
    responses={
        status.HTTP_200_OK: openapi.Schema(
            type=openapi.TYPE_OBJECT, properties={
                'user_data': openapi.Schema(type=openapi.TYPE_OBJECT, properties={
                    'req_id': openapi.Schema(
                        description='Уникальный идентификатор запроса VH',
                        type=openapi.TYPE_STRING
                    )
                }),
                'apphost-reqid': openapi.Schema(
                    description='Другой уникальный идентификатор запроса VH',
                    type=openapi.TYPE_STRING
                ),
                'seasons': openapi.Schema(type=openapi.TYPE_ARRAY, items=season_schema)
            }),
    },
    query_serializer=serializers.SeriesSeasonsValidator,
    manual_parameters=PlatformParamsSchemaProvider.get(),
)

EpisodeSpec = dict(
    operation_description='API получения эпизодов сезона',
    operation_summary='API получения эпизодов сезона',
    responses={
        status.HTTP_200_OK: openapi.Schema(
            type=openapi.TYPE_OBJECT, properties={
                'user_data': openapi.Schema(type=openapi.TYPE_OBJECT, properties={
                    'req_id': openapi.Schema(
                        description='Уникальный идентификатор запроса VH',
                        type=openapi.TYPE_STRING
                    )
                }),
                'apphost-reqid': openapi.Schema(
                    description='Другой уникальный идентификатор запроса VH',
                    type=openapi.TYPE_STRING
                ),
                'episodes': openapi.Schema(type=openapi.TYPE_ARRAY, items=episode_schema)
            }),
    },
    query_serializer=serializers.SeriesEpisodesValidator,
    manual_parameters=PlatformParamsSchemaProvider.get(),
)
