from drf_yasg import openapi
from rest_framework import status
from smarttv.utils import headers
from smarttv.droideka.proxy.swagger.base import PlatformParamsSchemaProvider
from smarttv.droideka.proxy.serializers import serializers


class SUWParamsSchemaProvider:
    @staticmethod
    def get():
        return PlatformParamsSchemaProvider.get() + [
            openapi.Parameter(
                name=headers.ETHERNET_MAC_HEADER,
                in_=openapi.IN_HEADER,
                description='Ethernet MAC устройства',
                type=openapi.TYPE_STRING,
                required=True
            ),
            openapi.Parameter(
                name=headers.WIFI_MAC_HEADER,
                in_=openapi.IN_HEADER,
                description='WiFi MAC устройства',
                type=openapi.TYPE_STRING,
                required=True
            ),
        ]


ActivationSpec = dict(
    query_serializer=serializers.BaseSetupWizardValidator,
    manual_parameters=SUWParamsSchemaProvider.get(),
    operation_description='Ручка активации устройства. В ней проверяется валидность идентификаторов и создаётся запись '
                          'в БД об устройстве, по которой позже выдаётся подарок.',
    operation_summary='Ручка активации устройства',
    responses={
        status.HTTP_204_NO_CONTENT: openapi.Response('Активация успешна'),
        status.HTTP_403_FORBIDDEN: openapi.Response('Ошибка активации. Ethernet MAС устройства неизвестен или '
                                                    'использовался в другой комбинации с WiFi MAC'),
    },
)

GetGiveGiftSpec = dict(
    query_serializer=serializers.BaseSetupWizardValidator,
    manual_parameters=SUWParamsSchemaProvider.get(),
    operation_description='Ручка выдачи подарка. В GET варианте отдаёт информацию о том, выдан ли был подарок и ID '
                          'для интеграции с кинопоисковой либой',
    operation_summary='Ручка выдачи подарков',
    responses={
        status.HTTP_200_OK: openapi.Schema(type=openapi.TYPE_OBJECT, properties={
            'gift_available': openapi.Schema(description='Выдан ли подарок', type=openapi.TYPE_BOOLEAN),
            'kp_gifts_id': openapi.Schema(description='ID устройсва для кинопоисковой либы',
                                          type=openapi.TYPE_STRING),
        }),
        status.HTTP_404_NOT_FOUND: openapi.Response('Информация об устройстве не найдена'),
    },
)


PostGiveGiftSpec = dict(
    query_serializer=serializers.BaseSetupWizardValidator,
    manual_parameters=SUWParamsSchemaProvider.get(),
    operation_description='Ручка выдачи подарка. В POST варианте выписывает промокод и применяет его',
    operation_summary='Ручка выдачи подарков',
    responses={
        status.HTTP_204_NO_CONTENT: openapi.Response('Подарок выдан успешно'),
        status.HTTP_403_FORBIDDEN: openapi.Response('Ошибка авторизации или подарокк уже выдан другому пользователю'),
        status.HTTP_404_NOT_FOUND: openapi.Response('Информация об устройстве в базе не найдена'),
        status.HTTP_503_SERVICE_UNAVAILABLE: openapi.Response('Ошибка при общении с API медиабиллинга'),
    },
)

UserAgreementSpec = dict(
    query_serializer=None,
    manual_parameters=None,
    operation_description='Ручка данных пользовательского соглашения. '
                          'Отображается на клиенте в Setup Wizard перед получением подарка. '
                          'Используются данные из админки sharedpreferences/user_agreement_text '
                          'и sharedpreferences/change/',
    operation_summary='Ручка данных пользовательского соглашения',
    responses={
        status.HTTP_200_OK: openapi.Schema(type=openapi.TYPE_OBJECT, properties={
            'text': openapi.Schema(description='Текст пользовательского соглашения', type=openapi.TYPE_STRING),
            'to_date': openapi.Schema(description='Дата окончания пользовательского соглашения',
                                      type=openapi.TYPE_STRING,
                                      pattern='dd.mm.yyyy'),
        })
    },
)


KpGiftsSpec = dict(
    query_serializer=serializers.KpGiftsGivenValidator,
    manual_parameters=None,
    operation_description='Постбэк о выдаче подарка со стороны Кинопоиска. '
                          'Дёргается сервером OTT при выдаче подарка либой КП. Поднимает флаг kp_gifts_given '
                          'у устройства в базе.',
    operation_summary='Постбэк о выдаче подарка со стороны Кинопоиска',
    responses={
        status.HTTP_204_NO_CONTENT: openapi.Response('Успешно'),
        status.HTTP_404_NOT_FOUND: openapi.Response('Информация об устройстве в базе не найдена'),
    }
)
