from django.contrib.admin.views.main import SEARCH_VAR
from django.contrib.admin.templatetags.admin_list import result_headers, result_hidden_fields, results

from django.template import Library

register = Library()


@register.inclusion_tag('activation_info/mac_search_form.html', takes_context=False)
def mac_search_form(cl):
    """
    Displays a search form for searching the list.
    """
    return {
        'cl': cl,
        'show_result_count': cl.result_count != cl.full_result_count,
        'search_var': SEARCH_VAR
    }


@register.inclusion_tag('activation_info/mac_result_list.html', takes_context=True)
def mac_result_list(context, cl):
    """
    Display the headers and data list together.
    """
    headers = list(result_headers(cl))
    num_sorted_fields = 0
    for h in headers:
        if h['sortable'] and h['sorted']:
            num_sorted_fields += 1
    return {
        'has_search_query': context.get('has_search_query'),
        'cl': cl,
        'result_hidden_fields': list(result_hidden_fields(cl)),
        'result_headers': headers,
        'num_sorted_fields': num_sorted_fields,
        'results': list(results(cl)),
    }
