from django.conf import settings
from django.utils.functional import SimpleLazyObject
from tvm2 import TVM2


class TicketError(Exception):
    pass


def build_tvm_client():
    return TVM2(
        client_id=settings.TVM_CLIENT_ID,
        secret=settings.TVM_CLIENT_SECRET,
        blackbox_client=settings.BLACKBOX_CLIENT,
        destinations=settings.TVM2_DESTINATIONS,
        allowed_clients=settings.TVM_ALLOWED_CLIENTS,
    )

tvm_client = SimpleLazyObject(build_tvm_client)


def add_service_ticket(destination, headers=None):
    headers = headers or {}

    ticket = tvm_client.get_service_ticket(destination)

    if not ticket:
        raise TicketError('Empty TVM service-ticket for destination: %s', destination)

    headers['X-Ya-Service-Ticket'] = ticket
    return headers


def check_service_ticket(ticket: str):
    parsed_ticket = tvm_client.parse_service_ticket(ticket)
    if not parsed_ticket:
        raise TicketError('Invalid TVM service-ticket')


def get_uid_from_user_ticket(ticket: str) -> int:
    parsed_ticket = tvm_client.parse_user_ticket(ticket)
    if parsed_ticket:
        return parsed_ticket.default_uid

    raise TicketError('Failed to parse user ticket')
