from django.conf.urls import re_path

from smarttv.droideka.proxy.views.card import CardDetailV4View, ThinCardDetailView, RatingsCardDetailV4
from smarttv.droideka.proxy.views.carousels import CarouselsV4View, CarouselV4View
from smarttv.droideka.proxy.views.categories import CategoriesView
from smarttv.droideka.proxy.views.channels import ChannelsView
from smarttv.droideka.proxy.views.doc2doc import Doc2DocV4View
from smarttv.droideka.proxy.views.programs import ProgramsView
from smarttv.droideka.proxy.views.screensaver import ScreenSaverView
from smarttv.droideka.proxy.views.search import SearchV4View, SuggestHistoryView, ParentCollectionView
from smarttv.droideka.proxy.views.setup_wizard import ActivationView, GiveGift, UserAgreement

# We decided to copy-paste same views for every version, instead of grouping versions like r'^v[1-5]/categories/?$'
# since, such approach solves the problem with copy-paste, but introduces 2 new problems:
# - When grouping like r'^v[1-5]/categories/?$', it's impossible to use different view name for every version
# - If using 'reverse' will be required - API version for reversed URL can be changed to unexpected, because of the
# same name
urlpatterns = [
    # API V4
    re_path(r'^v4/categories/?$', CategoriesView.as_view(), name='categories4'),
    re_path(r'^v4/carousels/?$', CarouselsV4View.as_view(), name=CarouselsV4View.NAME),
    re_path(r'^v4/carousel/?$', CarouselV4View.as_view(), name=CarouselV4View.NAME),
    re_path(r'^v4/doc2doc/?$', Doc2DocV4View.as_view(), name='doc2doc4'),
    re_path(r'^v4/card_detail/?$', CardDetailV4View.as_view(), name='card_detail4'),
    re_path(r'^v4/card_detail/thin/?$', ThinCardDetailView.as_view(), name='thin_card_detail4'),
    re_path(r'^v4/card_detail/ratings/?$', RatingsCardDetailV4.as_view(), name='ratings_card_detail4'),
    re_path(r'^v4/search/?$', SearchV4View.as_view(), name=SearchV4View.NAME),
    re_path(r'^v4/search/parent_collection/?$', ParentCollectionView.as_view(), name=ParentCollectionView.NAME),
    re_path(r'^v4/suggest_history/?$', SuggestHistoryView.as_view(), name='suggest_history4'),
    re_path(r'^v4/programs/?$', ProgramsView.as_view(), name='programs4'),
    re_path(r'^v4/screensaver/?$', ScreenSaverView.as_view(), name='screensaver4'),
    re_path(r'^v4/channels/?$', ChannelsView.as_view(), name='channels4'),
    re_path(r'^v4/suw/activation/?$', ActivationView.as_view(), name='activation4'),
    re_path(r'^v4/suw/gift/?$', GiveGift.as_view(), name='gift4'),
    re_path(r'^v4/suw/useragreement/?$', UserAgreement.as_view(), name='useragreement4'),
]
