from django.conf.urls import re_path

from smarttv.droideka.proxy.views.card import CardDetailV4View, ThinCardDetailView, RatingsCardDetail
from smarttv.droideka.proxy.views.carousels import CarouselsV5View, CarouselV5View
from smarttv.droideka.proxy.views.categories import CategoriesView
from smarttv.droideka.proxy.views.channels import ChannelsView
from smarttv.droideka.proxy.views.doc2doc import Doc2DocV4View
from smarttv.droideka.proxy.views.programs import ProgramsView, AllPrograms
from smarttv.droideka.proxy.views.screensaver import ScreenSaverView
from smarttv.droideka.proxy.views.search import SuggestHistoryView, SearchViewV5, ParentCollectionViewV5
from smarttv.droideka.proxy.views.setup_wizard import ActivationView, GiveGift, UserAgreement
from smarttv.droideka.proxy.views.plus import PlusSubscription
from smarttv.droideka.proxy.views.force_sync import ForceSyncView

urlpatterns = [
    # API v5
    re_path(r'^v5/categories/?$', CategoriesView.as_view(), name='categories5'),
    re_path(r'^v5/carousels/?$', CarouselsV5View.as_view(), name=CarouselsV5View.NAME),
    re_path(r'^v5/carousel/?$', CarouselV5View.as_view(), name=CarouselV5View.NAME),
    re_path(r'^v5/doc2doc/?$', Doc2DocV4View.as_view(), name='doc2doc5'),
    re_path(r'^v5/card_detail/?$', CardDetailV4View.as_view(), name='card_detail5'),
    re_path(r'^v5/card_detail/thin/?$', ThinCardDetailView.as_view(), name='thin_card_detail5'),
    re_path(r'^v5/card_detail/ratings/?$', RatingsCardDetail.as_view(), name='ratings_card_detail5'),
    re_path(r'^v5/search/?$', SearchViewV5.as_view(), name=SearchViewV5.NAME),
    re_path(r'^v5/search/parent_collection/?$', ParentCollectionViewV5.as_view(), name=ParentCollectionViewV5.NAME),
    re_path(r'^v5/suggest_history/?$', SuggestHistoryView.as_view(), name='suggest_history5'),
    re_path(r'^v5/programs/?$', ProgramsView.as_view(), name='programs5'),
    re_path(r'^v5/programs/all/?$', AllPrograms.as_view(), name='allprograms5'),
    re_path(r'^v5/screensaver/?$', ScreenSaverView.as_view(), name='screensaver5'),
    re_path(r'^v5/channels/?$', ChannelsView.as_view(), name='channels5'),
    re_path(r'^v5/suw/activation/?$', ActivationView.as_view(), name='activation5'),
    re_path(r'^v5/suw/gift/?$', GiveGift.as_view(), name='gift5'),
    re_path(r'^v5/suw/useragreement/?$', UserAgreement.as_view(), name='useragreement5'),
    re_path(r'^v5/subscription/?$', PlusSubscription.as_view(), name=PlusSubscription.NAME),
    re_path(r'^v5/forcesync/?$', ForceSyncView.as_view(), name='forcesync5'),
]
