from django.conf.urls import re_path

from smarttv.droideka.proxy.views.base import CheckAuthView
from smarttv.droideka.proxy.views.card import CardDetailV6View, ThinCardDetailView, RatingsCardDetail
from smarttv.droideka.proxy.views.carousels import CarouselsV6View, CarouselV6View
from smarttv.droideka.proxy.views.categories import CategoriesView
from smarttv.droideka.proxy.views.channels import ChannelsView
from smarttv.droideka.proxy.views.doc2doc import Doc2DocV6View
from smarttv.droideka.proxy.views.programs import ProgramsView, AllPrograms
from smarttv.droideka.proxy.views.screensaver import ScreenSaverView
from smarttv.droideka.proxy.views.search import SuggestHistoryView, SearchViewV6, ParentCollectionViewV6
from smarttv.droideka.proxy.views.series import SeasonsView, EpisodesView
from smarttv.droideka.proxy.views.setup_wizard import ActivationView, GiveGift, UserAgreement, KpGiftsGiven
from smarttv.droideka.proxy.views.force_sync import ForceSyncView
from smarttv.droideka.proxy.views.experiments import ExperimentsView

urlpatterns = [
    # API v6
    re_path(r'^v6/categories/?$', CategoriesView.as_view(), name='categories6'),
    re_path(r'^v6/carousels/?$', CarouselsV6View.as_view(), name=CarouselsV6View.NAME),
    re_path(r'^v6/carousel/?$', CarouselV6View.as_view(), name=CarouselV6View.NAME),
    re_path(r'^v6/doc2doc/?$', Doc2DocV6View.as_view(), name='doc2doc6'),
    re_path(r'^v6/card_detail/?$', CardDetailV6View.as_view(), name='card_detail6'),
    re_path(r'^v6/card_detail/thin/?$', ThinCardDetailView.as_view(), name='thin_card_detail6'),
    re_path(r'^v6/card_detail/ratings/?$', RatingsCardDetail.as_view(), name='ratings_card_detail6'),
    re_path(r'^v6/search/?$', SearchViewV6.as_view(), name=SearchViewV6.NAME),
    re_path(r'^v6/search/parent_collection/?$', ParentCollectionViewV6.as_view(), name=ParentCollectionViewV6.NAME),
    re_path(r'^v6/suggest_history/?$', SuggestHistoryView.as_view(), name='suggest_history6'),
    re_path(r'^v6/programs/?$', ProgramsView.as_view(), name='programs6'),
    re_path(r'^v6/programs/all/?$', AllPrograms.as_view(), name='allprograms6'),
    re_path(r'^v6/screensaver/?$', ScreenSaverView.as_view(), name='screensaver6'),
    re_path(r'^v6/channels/?$', ChannelsView.as_view(), name='channels6'),
    re_path(r'^v6/suw/activation/?$', ActivationView.as_view(), name='activation6'),
    re_path(r'^v6/suw/gift/?$', GiveGift.as_view(), name='gift6'),
    re_path(r'^v6/suw/useragreement/?$', UserAgreement.as_view(), name='useragreement6'),
    re_path(r'^v6/suw/kp_gifts_given/?$', KpGiftsGiven.as_view(), name='gift6'),
    re_path(r'^v6/series/seasons/?$', SeasonsView.as_view(), name=SeasonsView.NAME),
    re_path(r'^v6/series/episodes/?$', EpisodesView.as_view(), name=EpisodesView.NAME),
    re_path(r'^v6/forcesync/?$', ForceSyncView.as_view(), name='forcesync6'),
    re_path(r'^v6/experiments/?$', ExperimentsView.as_view(), name='experiments6'),
    re_path(r'^v6/check_auth/?$', CheckAuthView.as_view(), name='check_auth6'),
]
