from django.conf.urls import re_path

from smarttv.droideka.proxy.views.base import CheckAuthView
from smarttv.droideka.proxy.views.card import CardDetailV7View, ThinCardDetailViewV7, \
    RatingsCardDetail, ProgressCardDetail
from smarttv.droideka.proxy.views.carousels import CarouselV8View, CarouselsV8View
from smarttv.droideka.proxy.views.categories import CategoriesView
from smarttv.droideka.proxy.views.channels import ChannelsViewV8
from smarttv.droideka.proxy.views.doc2doc import Doc2DocV7View
from smarttv.droideka.proxy.views.programs import ProgramsView, AllPrograms
from smarttv.droideka.proxy.views.screensaver import ScreenSaverView
from smarttv.droideka.proxy.views.search import SuggestHistoryView, SearchViewV7, ParentCollectionViewV7, \
    AliceSearchV7, AliceParentCollectionV7, AliceTopTenV8
from smarttv.droideka.proxy.views.series import SeasonsViewV7, EpisodesViewV7, UnboundEpisodesView
from smarttv.droideka.proxy.views.setup_wizard import ActivationView, GiveGift, UserAgreement, KpGiftsGiven
from smarttv.droideka.proxy.views.force_sync import ForceSyncView
from smarttv.droideka.proxy.views.experiments import ExperimentsView
from smarttv.droideka.proxy.views.filmography import FilmographyView
from smarttv.droideka.proxy.views.smotreshka import SmotreshkaTvPlaybackBeginView

urlpatterns = [
    # API v8
    re_path(r'^v8/categories/?$', CategoriesView.as_view(), name='categories7'),
    re_path(r'^v8/carousels/?$', CarouselsV8View.as_view(), name=CarouselsV8View.NAME),
    re_path(r'^v8/carousel/?$', CarouselV8View.as_view(), name=CarouselV8View.NAME),
    re_path(r'^v8/doc2doc/?$', Doc2DocV7View.as_view(), name='doc2doc7'),
    re_path(r'^v8/card_detail/?$', CardDetailV7View.as_view(), name='card_detail7'),
    re_path(r'^v8/card_detail/thin/?$', ThinCardDetailViewV7.as_view(), name='thin_card_detail7'),
    re_path(r'^v8/card_detail/ratings/?$', RatingsCardDetail.as_view(), name='ratings_card_detail7'),
    re_path(r'^v8/card_detail/progress/?$', ProgressCardDetail.as_view(), name='progress_card_detail7'),
    re_path(r'^v8/search/?$', SearchViewV7.as_view(), name=SearchViewV7.NAME),
    re_path(r'^v8/alice/search/?$', AliceSearchV7.as_view(), name=AliceSearchV7.NAME),
    re_path(r'^v8/alice/topten/?$', AliceTopTenV8.as_view(), name=AliceTopTenV8.NAME),
    re_path(r'^v8/suggest_history/?$', SuggestHistoryView.as_view(), name='suggest_history7'),
    re_path(r'^v8/search/parent_collection/?$', ParentCollectionViewV7.as_view(), name=ParentCollectionViewV7.NAME),
    re_path(r'^v8/alice/search/parent_collection/?$', AliceParentCollectionV7.as_view(), name=AliceParentCollectionV7.NAME),
    re_path(r'^v8/programs/?$', ProgramsView.as_view(), name='programs7'),
    re_path(r'^v8/programs/all/?$', AllPrograms.as_view(), name='allprograms7'),
    re_path(r'^v8/screensaver/?$', ScreenSaverView.as_view(), name='screensaver7'),
    re_path(r'^v8/channels/?$', ChannelsViewV8.as_view(), name='channels8'),
    re_path(r'^v8/suw/activation/?$', ActivationView.as_view(), name='activation7'),
    re_path(r'^v8/suw/gift/?$', GiveGift.as_view(), name='gift7'),
    re_path(r'^v8/suw/useragreement/?$', UserAgreement.as_view(), name='useragreement7'),
    re_path(r'^v8/suw/kp_gifts_given/?$', KpGiftsGiven.as_view(), name='gift7'),
    re_path(r'^v8/series/seasons/?$', SeasonsViewV7.as_view(), name=SeasonsViewV7.NAME),
    re_path(r'^v8/series/episodes/?$', EpisodesViewV7.as_view(), name=EpisodesViewV7.NAME),
    re_path(r'^v8/series/unbound_episodes/?$', UnboundEpisodesView.as_view(), name=UnboundEpisodesView.NAME),
    re_path(r'^v8/forcesync/?$', ForceSyncView.as_view(), name='forcesync7'),
    re_path(r'^v8/experiments/?$', ExperimentsView.as_view(), name='experiments7'),
    re_path(r'^v8/check_auth/?$', CheckAuthView.as_view(), name='check_auth7'),
    re_path(r'^v8/filmography/?$', FilmographyView.as_view(), name=FilmographyView.NAME),
    re_path(r'^v8/smotreshka/begin/?$', SmotreshkaTvPlaybackBeginView.as_view(), name=SmotreshkaTvPlaybackBeginView.NAME),
]
