from django.urls import re_path

from smarttv.droideka.proxy.views.base import CheckAuthView
from smarttv.droideka.proxy.views.card import CardDetailV9View, ThinCardDetailViewV7, \
    RatingsCardDetail, ProgressCardDetail
from smarttv.droideka.proxy.views.carousels import CarouselV9View, CarouselsV9View
from smarttv.droideka.proxy.views.categories import CategoriesView
from smarttv.droideka.proxy.views.channels import ChannelsViewV8
from smarttv.droideka.proxy.views.doc2doc import Doc2DocV7View
from smarttv.droideka.proxy.views.programs import ProgramsView, AllPrograms
from smarttv.droideka.proxy.views.screensaver import ScreenSaverView
from smarttv.droideka.proxy.views.search import SuggestHistoryView, SearchViewV7, ParentCollectionViewV7, \
    AliceSearchV7, AliceParentCollectionV7, AliceTopTenV8
from smarttv.droideka.proxy.views.series import SeasonsViewV7, EpisodesViewV7, UnboundEpisodesView
from smarttv.droideka.proxy.views.setup_wizard import ActivationView, GiveGift, UserAgreement, KpGiftsGiven
from smarttv.droideka.proxy.views.force_sync import ForceSyncView
from smarttv.droideka.proxy.views.experiments import ExperimentsView
from smarttv.droideka.proxy.views.filmography import FilmographyView
from smarttv.droideka.proxy.views.smotreshka import SmotreshkaTvPlaybackBeginView

urlpatterns = [
    re_path(r'^v9/categories/?$', CategoriesView.as_view(), name='categories_v9'),
    re_path(r'^v9/carousels/?$', CarouselsV9View.as_view(), name=CarouselsV9View.NAME),
    re_path(r'^v9/carousel/?$', CarouselV9View.as_view(), name=CarouselV9View.NAME),
    re_path(r'^v9/doc2doc/?$', Doc2DocV7View.as_view(), name='doc2doc_v9'),
    re_path(r'^v9/card_detail/?$', CardDetailV9View.as_view(), name=CardDetailV9View.NAME),
    re_path(r'^v9/card_detail/thin/?$', ThinCardDetailViewV7.as_view(), name='card_detail_thin_v9'),
    re_path(r'^v9/card_detail/ratings/?$', RatingsCardDetail.as_view(), name='card_detail_ratings_v9'),
    re_path(r'^v9/card_detail/progress/?$', ProgressCardDetail.as_view(), name='card_detail_progress_v9'),
    re_path(r'^v9/search/?$', SearchViewV7.as_view(), name='search_v9'),
    re_path(r'^v9/alice/search/?$', AliceSearchV7.as_view(), name='alice_search_v9'),
    re_path(r'^v9/alice/topten/?$', AliceTopTenV8.as_view(), name='alice_topten_v9'),
    re_path(r'^v9/suggest_history/?$', SuggestHistoryView.as_view(), name='suggest_history_v9'),
    re_path(r'^v9/search/parent_collection/?$', ParentCollectionViewV7.as_view(), name='parent_collection_v9'),
    re_path(r'^v9/alice/search/parent_collection/?$', AliceParentCollectionV7.as_view(), name='alice_parent_collection_v9'),
    re_path(r'^v9/programs/?$', ProgramsView.as_view(), name='programs_v9'),
    re_path(r'^v9/programs/all/?$', AllPrograms.as_view(), name='programs_all_v9'),
    re_path(r'^v9/screensaver/?$', ScreenSaverView.as_view(), name='screensaver_v9'),
    re_path(r'^v9/channels/?$', ChannelsViewV8.as_view(), name='channels_v9'),
    re_path(r'^v9/suw/activation/?$', ActivationView.as_view(), name='activation_v9'),
    re_path(r'^v9/suw/gift/?$', GiveGift.as_view(), name='gift_v9'),
    re_path(r'^v9/suw/useragreement/?$', UserAgreement.as_view(), name='useragreement_v9'),
    re_path(r'^v9/suw/kp_gifts_given/?$', KpGiftsGiven.as_view(), name='kp_gifts_given_v9'),
    re_path(r'^v9/series/seasons/?$', SeasonsViewV7.as_view(), name='seasons_v9'),
    re_path(r'^v9/series/episodes/?$', EpisodesViewV7.as_view(), name='episodes_v9'),
    re_path(r'^v9/series/unbound_episodes/?$', UnboundEpisodesView.as_view(), name='unbound_episodes_v9'),
    re_path(r'^v9/forcesync/?$', ForceSyncView.as_view(), name='forcesync_v9'),
    re_path(r'^v9/experiments/?$', ExperimentsView.as_view(), name='experiments_v9'),
    re_path(r'^v9/check_auth/?$', CheckAuthView.as_view(), name='check_auth_v9'),
    re_path(r'^v9/filmography/?$', FilmographyView.as_view(), name='filmography_v9'),
    re_path(r'^v9/smotreshka/begin/?$', SmotreshkaTvPlaybackBeginView.as_view(), name='smotreshka_begin_v9'),
]
