import logging

from rest_framework.response import Response

from smarttv.droideka.proxy import api
from smarttv.droideka.proxy.swagger import base as swagger_base, doc2doc as swagger_doc2doc
from smarttv.droideka.proxy.serializers.fast_response import Doc2DocSerializer, Doc2DocV6Serializer, NEED_MAP_URL
from smarttv.droideka.proxy.serializers.serializers import Doc2DocRequestValidator
from smarttv.droideka.proxy.views.base import PlatformAPIView
from smarttv.droideka.proxy.common import ensure_ott_content_id

logger = logging.getLogger(__name__)


class PlatformDoc2DocView(PlatformAPIView):
    validator_class = Doc2DocRequestValidator
    response_serializer = None
    need_map_url = False

    def get(self, request):
        data = self.get_validated_data(request)
        content_id = data['content_id']
        ensure_ott_content_id(content_id)

        response = api.vh.client.doc2doc(
            initial_request=request,
            headers=self.vh_headers(request),
            content_id=content_id,
            offset=data['offset'],
            limit=data['limit'],
            rvb=data['rvb'],
            restriction_age=data['restriction_age']
        )
        result = self.prepare_result(response, request.platform_info)

        return Response(status=200, data=result)

    def prepare_result(self, response, platform_info):
        serializer_context = {'platform_info': platform_info, NEED_MAP_URL: self.need_map_url}

        result = self.response_serializer.serialize(obj=response, context=serializer_context)
        api.vh.propagate_vh_tracking_params(response, result)

        return result


class Doc2DocV4View(PlatformDoc2DocView):
    response_serializer = Doc2DocSerializer()
    need_map_url = False

    @swagger_base.swagger_schema(swagger_doc2doc.Doc2DocV4Spec)
    def get(self, request):
        return super().get(request)


class Doc2DocV6View(PlatformDoc2DocView):
    response_serializer = Doc2DocV6Serializer()
    need_map_url = False

    @swagger_base.swagger_schema(swagger_doc2doc.Doc2DocV6Spec)
    def get(self, request):
        return super().get(request)


class Doc2DocV7View(PlatformDoc2DocView):
    response_serializer = Doc2DocV6Serializer()
    need_map_url = False

    @swagger_base.swagger_schema(swagger_doc2doc.Doc2DocV6Spec)
    def get(self, request):
        return super().get(request)
