from rest_framework.response import Response

from smarttv.droideka.proxy.views.base import PlatformAPIView
from smarttv.droideka.proxy.api.ott import client as ott_client
from smarttv.droideka.proxy.serializers.protobuf import FilmographyResultSerializer
from smarttv.droideka.proxy.serializers.serializers import FilmographyValidator
from smarttv.droideka.proxy.serializers.protobuf import CTX_PLATFORM_INFO

from alice.protos.data.search_result.search_result_pb2 import TSearchResultData

from google.protobuf import json_format

import logging


logger = logging.getLogger(__name__)

FIELD_PERSON_ID = 'person_id'


class FilmographyView(PlatformAPIView):
    NAME = 'filmography'
    validator_class = FilmographyValidator

    def get(self, request):
        validated_data = self.get_validated_data(request)
        response = ott_client.get_filmography(validated_data[FIELD_PERSON_ID], self.vh_headers(request),
                                              initial_request=request)
        result = TSearchResultData()
        FilmographyResultSerializer().serialize(response, result, {CTX_PLATFORM_INFO: request.platform_info})
        return Response(status=200, data=json_format.MessageToDict(result))
