import logging

from rest_framework.response import Response

from smarttv.droideka.proxy import models
from smarttv.droideka.proxy.views.base import PlatformAPIView
from smarttv.droideka.proxy.constants.reserved_shared_pref_keys import KEY_PROGRAMS

logger = logging.getLogger(__name__)


class ForceSyncView(PlatformAPIView):
    need_kp_profile_creation = False

    def get(self, request):
        logger.info('Force sync data start')
        programs_sync_label = models.SharedPreferences.get_int(KEY_PROGRAMS)
        logger.info('Force sync data end')

        result = {}
        if programs_sync_label is not None:
            result['programs'] = programs_sync_label

        return Response(result)
