from django.http.response import HttpResponse, HttpResponseBadRequest, HttpResponseForbidden, JsonResponse
from django.views.decorators.csrf import csrf_exempt

from smarttv.droideka.proxy.identifiers import IdentifiersImporter
from smarttv.droideka.proxy.tvm import tvm_client
from smarttv.utils.django import get_http_header
from smarttv.utils.headers import TVM_SERVICE_TICKET

# около 500 к маков, байт
MAX_POST_BODY_SIZE = 10_000_000


@csrf_exempt
def upload_macs(request):
    """
    Загрузка маков в дройдеку

    Маки присылает постом админка plant, когда там импортируются новые устройства
    """
    if request.method == 'POST':
        ticket = get_http_header(request, TVM_SERVICE_TICKET)
        if not ticket:
            return HttpResponseForbidden('No ticket')
        parsed = tvm_client.parse_service_ticket(ticket)
        if not parsed:
            return HttpResponseForbidden('Incorrect ticket')

        body = request.read(MAX_POST_BODY_SIZE)
        if request.read(1) != b'':
            return HttpResponseBadRequest('Request body too large')

        result = IdentifiersImporter.import_from_string(body.split(b'\n'))
        return JsonResponse(result.as_dict())

    return HttpResponse('Please use POST method with macs in body, macs separated by \\n\n',
                        status=405)
