import logging

from rest_framework.response import Response
from smarttv.droideka.proxy.views.base import APIView, PlatformMixin

logger = logging.getLogger(__name__)


class PlusSubscription(PlatformMixin, APIView):
    NAME = 'plus_subscription'

    authorization_required = True

    def get(self, request):
        user_info = self.get_user_info(request)
        content = {
            'subscription': {
                'name': user_info.subscription.value
            }
        }
        return Response(content)
