import logging

from rest_framework.response import Response
from django.conf import settings

from smarttv.droideka.proxy.models import ScreenSaver, get_entity_actual_version
from smarttv.droideka.proxy.serializers.serializers import ScreenSaverValidator
from smarttv.droideka.proxy.serializers.response import ScreenSaverSerializer
from smarttv.droideka.proxy.swagger.base import smarttv_swagger_schema
from smarttv.droideka.proxy.swagger.screensaver import ScreenSaverSpec
from smarttv.droideka.proxy.views.base import NoExperimentsMixin, PlatformAPIView

logger = logging.getLogger(__name__)


class ScreenSaverView(NoExperimentsMixin, PlatformAPIView):
    validator_class = ScreenSaverValidator

    @smarttv_swagger_schema(ScreenSaverSpec, 'Получение скринсейверов')
    def get(self, request):
        params = self.get_validated_data(request)
        version = get_entity_actual_version(ScreenSaver.get_entity())
        if not version:
            logger.debug('No screen savers found')
            return Response([])
        offset = params['offset']
        limit = params['limit']
        media_type = params['type']
        logger.debug(f'offset: {offset}, limit: {limit}')
        data = list(ScreenSaver.objects.using(settings.DB_REPLICA).filter(
            version=version.version,
            visible=True,
            resolution__in=params['resolutions'],
            type__in=[media_type])[offset:offset + limit])
        serializer = ScreenSaverSerializer(data, many=True)
        return Response({'type': media_type, 'media': serializer.data})
