PY3_LIBRARY()

OWNER(g:smarttv)

PEERDIR(
    library/python/blackbox
    library/python/cityhash
    library/python/tvm2
    library/python/yenv

    contrib/python/boto3
    contrib/python/botocore
    contrib/python/django/django-2.2
    contrib/python/django-cache-memoize
    contrib/python/djangorestframework
    contrib/python/drf-yasg
    contrib/python/furl
    contrib/python/gevent
    contrib/python/psycopg2
    contrib/python/redis
    contrib/python/requests
    contrib/python/sentry-sdk
    contrib/python/ujson

    geobase/python/static
    plus/utils
    smarttv/utils
    yaphone/utils/django
    yaphone/utils/parsers
    yaphone/utils/parsed_version

    smarttv/droideka/proxy/migrations
    smarttv/droideka/unistat
    smarttv/droideka/utils

    alice/protos/data/search_result
    alice/protos/data/filmography_result
    alice/protos/data/video
    alice/memento/proto
    alice/nlu/py_libs/request_normalizer

    smarttv/droideka/protos/profile
)

PY_SRCS(
    admin.py
    apps.py
    common.py
    serializers/base.py
    serializers/serializers.py
    serializers/fast_response.py
    serializers/response.py
    serializers/fields.py
    serializers/protobuf.py
    urls/intapi.py
    urls/old.py
    urls/v5.py
    urls/v6.py
    urls/v7.py
    urls/v8.py
    urls/v9.py
    api/__init__.py
    api/alice.py
    api/base.py
    api/access_config.py
    api/vh.py
    api/es.py
    api/vs.py
    api/ott.py
    api/usaas.py
    api/music.py
    api/mediabilling.py
    api/memento.py
    api/smotreshka.py
    exceptions.py
    data_source.py
    result_builder.py
    player_detection.py
    forms.py
    mem_cache.py

    management/commands/upload_identifiers.py
    management/commands/generate_kp_carousels.py
    management/commands/download_programs.py
    management/commands/get_programs_s3_upload_key.py
    management/commands/save_current_programs.py

    views/base.py
    views/categories.py
    views/carousels.py
    views/programs.py
    views/doc2doc.py
    views/card.py
    views/search.py
    views/screensaver.py
    views/channels.py
    views/setup_wizard.py
    views/intapi.py
    views/plus.py
    views/series.py
    views/force_sync.py
    views/experiments.py
    views/filmography.py
    views/smotreshka.py

    swagger/base.py
    swagger/card.py
    swagger/check_auth.py
    swagger/doc2doc.py
    swagger/programs.py
    swagger/screensaver.py
    swagger/search.py
    swagger/series.py
    swagger/categories.py
    swagger/carousels.py
    swagger/episode_spec.py
    swagger/avatars_image_generator_spec.py
    swagger/setup_wizard.py

    vh/constants.py

    avatars_image_generator.py
    cinema.py
    licenses.py
    identifiers.py
    models.py
    s3mds.py
    smotreshka.py
    transform.py
    blackbox.py
    tvm.py
    categories_provider.py
    kp_profile.py

    constants/__init__.py
    constants/base.py
    constants/carousels.py
    constants/reserved_shared_pref_keys.py
    constants/card.py
    constants/home_app_versions.py
    constants/orientation.py
    request/__init__.py
    request/carousels.py
    request/promo.py
    response/__init__.py
    response/carousels.py

    cache.py

    templatetags/droideka_list.py

    periodic_task.py
)

RESOURCE_FILES(
    PREFIX smarttv/droideka/proxy/
    templates/valid_identifier/changelist.html
    templates/valid_identifier/upload.html
    templates/activation_info/get.html
    templates/activation_info/mac_search_form.html
    templates/activation_info/mac_result_list.html
)

END()
