# Add metric to this file before using it in code.
# We have to initialize all counters in master process, before fork

# Global counters — constantly rising

from enum import Enum
from smarttv.utils.unistat import TIMING_HGRAM_BINS, path_to_signal

# Some other metrics
SUMM_COUNTERS = [
    'ping_count',
    'experiment_errors',
]

RESPONSE_STATUSES = ('2xx', '4xx', '5xx', 'error', 'retry', 'parseerror')
EXTERNAL_SERVICES = ('vh', 'entity', 'search', 'ott', 'uaas', 'suggest', 'aliceb2b',
                     'music', 'memento', 'smotreshka', 'smotreshka_billing')
# from proxy/urls/v7.py
HANDLERS = (
    '/api/v7/categories',
    '/api/v7/carousels',
    '/api/v7/carousel',
    '/api/v7/doc2doc',
    '/api/v7/card_detail',
    '/api/v7/card_detail/thin',
    '/api/v7/card_detail/ratings',
    '/api/v7/card_detail/progress',
    '/api/v7/search',
    '/api/v7/alice/search',
    '/api/v7/suggest_history',
    '/api/v7/search/parent_collection',
    '/api/v7/alice/search/parent_collection',
    '/api/v7/programs',
    '/api/v7/programs/all',
    '/api/v7/screensaver',
    '/api/v7/channels',
    '/api/v7/suw/activation',
    '/api/v7/suw/gift',
    '/api/v7/suw/useragreement',
    '/api/v7/suw/kp_gifts_given',
    '/api/v7/series/seasons',
    '/api/v7/series/episodes',
    '/api/v7/series/unbound_episodes',
    '/api/v7/forcesync',
    '/api/v7/experiments',
    '/api/v7/check_auth',
    '/api/v8/channels',
    '/api/v8/alice/topten'
)


class RedisCachePlace(Enum):
    CHANNELS_RESPONSE = 'channels_response'
    THIN_CARD_DETAIL = 'thin_card_detail'
    RATINGS_CARD_DETAIL = 'ratings_card_detail'
    KP_PROFILE_CACHE = 'kp_profile_cache'


class LocalCachePlace(Enum):
    RAW_CATEGORIES = 'raw_categories'
    CATEGORIES_NON_PUBLISHED = 'categories_non_published'
    PROMO = 'promo'
    V4_EPISODES = 'v4_episodes'
    CHILD_CATEGORIES_BY_PARENT_ID = 'chld_ctg_by_prnt_id'
    NORMALIZED_TITLE = 'normalized_title'


def get_request_counter_name(service, response_status) -> str:
    return f'request_{service}_{response_status}'


def get_signal_counters(base: str) -> tuple[str, str, str, str, str]:
    return (f'call-{base}-cnt',
            f'call-{base}-fail',
            f'call-{base}-fail-4xx',
            f'call-{base}-fail-5xx',
            f'call-{base}-err')


class CacheType(Enum):
    REDIS = 'redis'
    LOCAL = 'local'


class CacheSignal:
    class Type(Enum):
        HIT = 'hit'
        MISS = 'miss'

    @staticmethod
    def get_cache_signal(signal: 'CacheSignal.Type', cache_place: str, cache_type: CacheType):
        return f'{cache_type.value}_{signal.value}_{cache_place}'


# SUW metrics
SUMM_COUNTERS.extend([
    'suw_activations',
    'suw_unknown_devices',
    'suw_activated_promocodes',
    'kp_profile_activation',
    'missing_quasar_device_id_header_count',
])

# Histogram counters
HGRAM_COUNTERS = []

# External services response counters and histograms
for service in EXTERNAL_SERVICES:
    for response_status in RESPONSE_STATUSES:
        SUMM_COUNTERS.append(get_request_counter_name(service, response_status))
    HGRAM_COUNTERS.append((get_request_counter_name(service, 'timing'), TIMING_HGRAM_BINS))

for path in HANDLERS:
    signal_name_base = path_to_signal(path)
    for signal in get_signal_counters(signal_name_base):
        SUMM_COUNTERS.append(signal)

    HGRAM_COUNTERS.append((f'call-{signal_name_base}-duration', TIMING_HGRAM_BINS))

redis_cache_place: RedisCachePlace
for redis_cache_place in RedisCachePlace:
    SUMM_COUNTERS.append(CacheSignal.get_cache_signal(CacheSignal.Type.HIT, redis_cache_place.value, CacheType.REDIS))
    SUMM_COUNTERS.append(CacheSignal.get_cache_signal(CacheSignal.Type.MISS, redis_cache_place.value, CacheType.REDIS))

local_cache_place: LocalCachePlace
for local_cache_place in LocalCachePlace:
    SUMM_COUNTERS.append(CacheSignal.get_cache_signal(CacheSignal.Type.HIT, local_cache_place.value, CacheType.LOCAL))
    SUMM_COUNTERS.append(CacheSignal.get_cache_signal(CacheSignal.Type.MISS, local_cache_place.value, CacheType.LOCAL))
