from django.conf import settings
from django.conf.urls import include, re_path
from django.views.static import serve
from drf_yasg.views import get_schema_view
from drf_yasg import openapi
from rest_framework import permissions

from plus.utils.db.migrations import has_pending_migrations, check_migrations

from smarttv.droideka.proxy.admin import admin_site
from smarttv.droideka.proxy.views.base import ping, unistat_handler
from django.http import HttpResponse
from django.views.decorators.http import require_GET
from smarttv.droideka.proxy.periodic_task import cache_update_task
from smarttv.droideka.profiling import ProfilingControlView

handler500 = 'rest_framework.exceptions.server_error'


@require_GET
def readiness_probe(_):
    if not cache_update_task.cache_filled:
        return HttpResponse('Project\'c cache not initialized yet', status=500)
    for database in settings.DATABASES:
        if has_pending_migrations(database):
            return HttpResponse('Project has pending migrations', status=500)
    return HttpResponse()


urlpatterns = [
    re_path(r'^ping/?', ping, name='ping'),
    re_path(r'^unistat/?', unistat_handler, name='unistat'),
    re_path(r'^check_migrations/?', check_migrations, name='check_migrations'),
    re_path(r'^toogle_profiling/?', ProfilingControlView.as_view(), name='toogle_profiling'),
    re_path(r'^readiness_probe/?', readiness_probe, name='readiness_probe'),
    re_path(r'^api/', include('smarttv.droideka.proxy.urls.old')),
    re_path(r'^api/', include('smarttv.droideka.proxy.urls.v5')),
    re_path(r'^api/', include('smarttv.droideka.proxy.urls.v6')),
    re_path(r'^api/', include('smarttv.droideka.proxy.urls.v7')),
    re_path(r'^api/', include('smarttv.droideka.proxy.urls.v8')),
    re_path(r'^api/', include('smarttv.droideka.proxy.urls.v9')),
    re_path(rf'^{settings.BASE_URL}/admin/', admin_site.urls),
    re_path(rf'^{settings.BASE_URL}/intapi/', include('smarttv.droideka.proxy.urls.intapi')),
    re_path(rf'^{settings.BASE_URL}/static/(?P<path>.*)$', serve, {'document_root': settings.STATIC_ROOT, 'show_indexes': False}),
    re_path(rf'^{settings.IDM_URL_PREFIX}', include('django_idm_api.urls')),
]

if settings.NEED_SWAGGER:
    schema_view = get_schema_view(
        openapi.Info(
            title="SmartTV API",
            default_version='v5',
            description="Описание бэкенда для Android и Web TV",
        ),
        public=True,
        permission_classes=(permissions.AllowAny,),
        patterns=[
            re_path(r'^api/', include('smarttv.droideka.proxy.urls.v5')),
            re_path(r'^api/', include('smarttv.droideka.proxy.urls.v6')),
            re_path(r'^api/', include('smarttv.droideka.proxy.urls.v7')),
        ],
    )
    urlpatterns += [
        re_path(r'^swagger(?P<format>\.json|\.yaml)$', schema_view.without_ui(cache_timeout=0), name='schema-json'),
        re_path(r'^swagger/$', schema_view.with_ui('swagger', cache_timeout=0), name='schema-swagger-ui'),
    ]
