from datetime import datetime, timedelta

from django.conf import settings

RATE = settings.DEFAULT_RESPONSE_CACHE_TIME


def reduce_accuracy(number, divisor=None):
    """Makes the number a multiple of the divisor."""
    divisor = divisor or RATE or 1
    if divisor:
        return int(number / divisor) * divisor
    else:
        return number


def yesterday_start():
    """
    Returns the timestamp equal to yesterday, 00:00
    Example:
        Today is 23 of april, 2020, 13:08
        This function will return timestamp equal to 22 of april, 2020, 00:00:00
    """
    date = datetime.today() - timedelta(days=1)
    beginning_of_yesterday = datetime(date.year, date.month, date.day)
    return reduce_accuracy(beginning_of_yesterday.timestamp())


def tomorrow_end():
    """
    Returns timestamp equal to tomorrow end of tomorrow, 23:59:59
    Example:
        Today is 23 of april, 2020, 13:08
        This function will return timestamp equal to 24 of april, 2020, 23:59:59
    """
    date = datetime.today() + timedelta(days=1)
    end_of_tomorrow = datetime(date.year, date.month, date.day, 23, 59, 59)
    return reduce_accuracy(end_of_tomorrow.timestamp())


def split_time_interval(from_time, to_time, hours=2):
    current = datetime.fromtimestamp(from_time)
    end_time = datetime.fromtimestamp(to_time)
    delta = timedelta(hours=hours)
    microsecond = timedelta(microseconds=1)
    result = []
    while current < end_time:
        start = current
        end = min(current + delta, end_time)
        almost_end = end - microsecond
        result.append(
            (reduce_accuracy(start.timestamp()), reduce_accuracy(almost_end.timestamp())))
        current = end
    return result
