import json
import types
import argparse


class InputParams:
    def __init__(self, json_input: list, key_column_name: str, value_column_name: str):
        self.json_input = json_input
        self.key_column_name = key_column_name
        self.value_column_name = value_column_name


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--json_input')
    parser.add_argument('--key_column_name')
    parser.add_argument('--value_column_name')
    parser.add_argument('--columns_mapping')
    return parser.parse_args()


def parse_inputs(args) -> InputParams:
    with open(args.json_input, encoding='utf-8') as f:
        json_input = json.load(f)
        if not isinstance(json_input, list):
            raise ValueError("'json_input' must be a list")
    return InputParams(json_input, args.key_column_name, args.value_column_name)


def save_results(result, args):
    if result is not None and args.columns_mapping:
        with open(args.columns_mapping, 'w', encoding='utf-8') as columns_mapping:
            columns_mapping.write(json.dumps(result, ensure_ascii=False, indent=4))


def make_mapping(input_params: InputParams) -> dict:
    result = {}
    for item in input_params.json_input:
        result[item[input_params.key_column_name]] = item[input_params.value_column_name]
    return result

def main():
    args = parse_args()
    input_params = parse_inputs(args)

    result = make_mapping(input_params)

    save_results(result, args)


if __name__ == '__main__':
    main()
