import yenv
from django.contrib import admin
from django.contrib.auth.models import Group, User
from smarttv.plant.plant import models
from plus.utils.yauth import YaAuthAdminSite


class AdminSite(YaAuthAdminSite):
    """
    Aдминка с авторизацией через yandex cookie
    """
    site_title = f'Django administration [{yenv.type}]'
    site_header = site_title


class OrderInline(admin.StackedInline):
    model = models.Order
    extra = 1
    show_change_link = True


class DeviceAdmin(admin.ModelAdmin):
    inlines = [OrderInline]
    list_display = ('model', 'brand')
    list_filter = ('need_attention', 'brand', 'factory', 'assembler')
    search_fields = ('brand__name', 'model', 'panel__name')

    def get_queryset(self, request):
        return super(DeviceAdmin, self).get_queryset(request).select_related('brand', 'panel', 'platform')


class OrderAdmin(admin.ModelAdmin):
    list_display = ('device', 'amount_plan', 'firmware')
    list_filter = ('device__brand', 'device__factory', 'need_attention')
    list_select_related = ('device__brand', 'device__panel', 'device__platform')

    autocomplete_fields = ('device',)


class MacsImportAdmin(admin.ModelAdmin):
    readonly_fields = ('device', 'created_at', 'imported_string')
    list_display = ('created_at', 'device')


class PlatformAdmin(admin.ModelAdmin):
    list_display = ('name', 'quasar_platform')


admin_site = AdminSite()
admin_site.register(User)
admin_site.register(Group)
admin_site.register(models.Brand)
admin_site.register(models.Factory)
admin_site.register(models.Partner)
admin_site.register(models.Platform, PlatformAdmin)
admin_site.register(models.Panel)
admin_site.register(models.Firmware)
admin_site.register(models.DeviceGroup)
admin_site.register(models.Device, DeviceAdmin)
admin_site.register(models.Order, OrderAdmin)
admin_site.register(models.MacsImport, MacsImportAdmin)
admin_site.register(models.MacAddress)
