import logging
import json

from smarttv.plant.plant.integrations.droideka import settings
from smarttv.plant.plant.integrations.http import HttpApi

logger = logging.getLogger(__name__)


class DroidekaApi(HttpApi):
    base_url = settings.DROIDEKA_INTAPI_URL

    use_tvm = True
    destination_tvm_id = settings.DROIDEKA_TVM_ID

    def upload_macs(self, macs: list[str]):
        """
        Загрузка маков в дройдеку для выдачи подарков
        """
        body = '\n'.join(macs)
        response = self.post('/upload_macs/', body=body)

        if response.status == 200:
            return json.loads(response.data.decode('utf-8'))

        raise self.StatusError(f'Droideka responded {response.status}: {response.data}')
