import logging
from urllib.parse import urljoin

import urllib3

from smarttv.plant.plant.tvm import get_service_ticket

logger = logging.getLogger(__name__)
pool_manager = urllib3.PoolManager()


class HttpApi:
    base_url = ''

    use_tvm = False
    destination_tvm_id = ''

    class APIError(Exception):
        pass

    class StatusError(APIError):
        pass

    class TvmError(APIError):
        pass

    def request(self, method: str, path='', body=None, fields=None, headers=None):

        if self.use_tvm:
            logger.debug('Adding TVM headers')
            headers = (headers or {}) | self.get_tvm_headers()

        url = self.build_url(path)
        logger.debug('%s %s', method, url)
        response = pool_manager.request(method, url, body=body, fields=fields, headers=headers)
        return response

    def post(self, path: str, body=None, fields=None, headers=None):
        return self.request('POST', path, body=body, fields=fields, headers=headers)

    def get(self, path: str, body=None, fields=None, headers=None):
        return self.request('GET', path, body=body, fields=fields, headers=headers)

    def get_tvm_headers(self) -> dict:
        if not self.destination_tvm_id:
            raise self.TvmError(f'Please set destination_tvm_id in {self.__class__.__name__}')
        return get_service_ticket(self.destination_tvm_id)

    def build_url(self, path):
        return urljoin(self.base_url, path.lstrip('/'))
