

def read_table_chunked(table_name: str, chunk_size: int, yt_client=None, **kwargs):
    start = 0
    end = chunk_size

    if chunk_size < 1:
        raise ValueError('Wrong chunk size')

    more = True
    while more:
        table_path = yt_client.TablePath(table_name, start_index=start, end_index=end, **kwargs)
        rows = yt_client.read_table(table_path)
        rows = list(rows)

        yield rows

        if len(rows) < chunk_size:
            more = False
            break

        start += chunk_size
        end += chunk_size
