from smarttv.utils.machelpers import unfold_interval, normalize_mac, validate_mac
from smarttv.plant.plant.models import MacAddress


class MacsImporter:
    class IncorrectMac(Exception):
        pass

    def run(self, import_session, device, macs_string):
        addresses = []

        for line in macs_string.split('\n'):
            line = line.strip()
            if not line:
                continue
            interval = unfold_interval(line)
            if interval:
                addresses.extend(interval)
            else:
                addresses.append(line)

        if not addresses:
            return

        insertions = []
        for address in addresses:
            if not validate_mac(normalize_mac(address)):
                raise self.IncorrectMac(f'Invalid address "{address}"')

            mac_object = MacAddress.from_string(address)
            mac_object.import_session = import_session
            mac_object.device = device
            insertions.append(mac_object)

        MacAddress.objects.bulk_create(insertions, ignore_conflicts=True)
