# Generated by Django 2.2.19 on 2021-02-25 02:49

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Assembler',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True, verbose_name='Название')),
            ],
            options={
                'verbose_name': 'Предприятие сборки',
                'verbose_name_plural': 'Предприятия сборки',
            },
        ),
        migrations.CreateModel(
            name='Brand',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True, verbose_name='Бренд')),
            ],
            options={
                'verbose_name': 'Бренд',
                'verbose_name_plural': 'Бренды',
            },
        ),
        migrations.CreateModel(
            name='Device',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('visible', models.BooleanField(default=False, verbose_name='Опубликовано')),
                ('model', models.CharField(blank=True, max_length=256, verbose_name='Модель')),
                ('screen_size', models.IntegerField(default=0, verbose_name='Диагональ экрана в дюймах')),
                ('resolution', models.CharField(choices=[('HD', 'HD'), ('FHD', 'FHD'), ('QHD', 'QHD'), ('UHD', 'UHD')], max_length=32, verbose_name='Разрешение')),
                ('firmware_ticket', models.CharField(blank=True, max_length=500, verbose_name='Ссылка на тикет прошивки')),
                ('need_attention', models.BooleanField(default=False, verbose_name='Требует внимания')),
                ('note', models.TextField(blank=True, verbose_name='Заметка (не публикуется)')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('assembler', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='plant.Assembler', verbose_name='Предприятие сборки')),
                ('brand', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='plant.Brand', verbose_name='Бренд')),
            ],
            options={
                'verbose_name': 'Устройство',
                'verbose_name_plural': 'Устройства',
            },
        ),
        migrations.CreateModel(
            name='DeviceGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250, verbose_name='Название группы')),
            ],
            options={
                'verbose_name': 'Группа устройств',
                'verbose_name_plural': 'Группы устройств',
            },
        ),
        migrations.CreateModel(
            name='Factory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True, verbose_name='Завод')),
            ],
            options={
                'verbose_name': 'Завод',
                'verbose_name_plural': 'Заводы',
            },
        ),
        migrations.CreateModel(
            name='Firmware',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('major', models.PositiveIntegerField(blank=True, default=0)),
                ('minor', models.PositiveIntegerField(blank=True, default=0)),
                ('patch', models.PositiveIntegerField(blank=True, default=0)),
                ('extra', models.CharField(blank=True, max_length=256, verbose_name='Суффикс')),
            ],
            options={
                'verbose_name': 'Версия прошивки',
                'verbose_name_plural': 'Версии прошивок',
            },
        ),
        migrations.CreateModel(
            name='Panel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True, verbose_name='Модель')),
                ('size', models.PositiveSmallIntegerField(blank=True, default=0)),
            ],
            options={
                'verbose_name': 'Панель',
                'verbose_name_plural': 'Панели',
            },
        ),
        migrations.CreateModel(
            name='Partner',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True, verbose_name='Партнер')),
            ],
            options={
                'verbose_name': 'Партнер',
                'verbose_name_plural': 'Партнеры',
            },
        ),
        migrations.CreateModel(
            name='Platform',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True, verbose_name='Платформа')),
            ],
            options={
                'verbose_name': 'Платформа',
                'verbose_name_plural': 'Платформы',
            },
        ),
        migrations.CreateModel(
            name='Order',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('visible', models.BooleanField(default=False, verbose_name='Опубликован')),
                ('firmware', models.CharField(blank=True, max_length=250, verbose_name='Имя прошивки')),
                ('firmware_link', models.CharField(blank=True, max_length=1000, verbose_name='Ссылка на прошивку')),
                ('amount_plan', models.PositiveIntegerField(default=0)),
                ('amount_fact', models.PositiveIntegerField(default=0)),
                ('skd_plan', models.DateField(blank=True, null=True)),
                ('skd_fact', models.DateField(blank=True, null=True)),
                ('assemble_plan', models.DateField(blank=True, null=True)),
                ('assemble_fact', models.DateField(blank=True, null=True)),
                ('need_attention', models.BooleanField(default=False, verbose_name='Требует внимания')),
                ('note', models.TextField(blank=True, verbose_name='Заметка (не публикуется)')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='plant.Device', verbose_name='Устройство')),
                ('firmware_version', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='plant.Firmware', verbose_name='Прошивка с завода')),
            ],
        ),
        migrations.AddField(
            model_name='device',
            name='factory',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='plant.Factory', verbose_name='Завод-изготовитель'),
        ),
        migrations.AddField(
            model_name='device',
            name='group',
            field=models.ForeignKey(blank=True, help_text='Устройства в одной группе одинаковые, но с разными названиями', null=True, on_delete=django.db.models.deletion.SET_NULL, to='plant.DeviceGroup', verbose_name='Группа'),
        ),
        migrations.AddField(
            model_name='device',
            name='latest_firmware',
            field=models.ForeignKey(blank=True, help_text='Последняя выложенная версия прошивки для этого устройства', null=True, on_delete=django.db.models.deletion.SET_NULL, to='plant.Firmware', verbose_name='Последняя прошивка'),
        ),
        migrations.AddField(
            model_name='device',
            name='panel',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='plant.Panel', verbose_name='Панель'),
        ),
        migrations.AddField(
            model_name='device',
            name='partner',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='plant.Partner', verbose_name='Партнер'),
        ),
        migrations.AddField(
            model_name='device',
            name='platform',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='plant.Platform', verbose_name='Платформа'),
        ),
    ]
