import logging

from django.conf import settings
from tvm2 import TVM2

logger = logging.getLogger(__name__)


class TicketError(Exception):
    pass


def get_tvm_client():
    return TVM2(
        client_id=settings.TVM_CLIENT_ID,
        secret=settings.TVM_CLIENT_SECRET,
        blackbox_client=settings.BLACKBOX_CLIENT,
        destinations=settings.TVM2_DESTINATIONS,
    )


def get_service_ticket(destination: str) -> dict[str, str]:
    ticket = get_tvm_client().get_service_ticket(destination)

    if not ticket:
        raise TicketError(f'Empty TVM service-ticket for destination {destination}')

    return {'X-Ya-Service-Ticket': ticket}
