import os
import sys
from gunicorn.app.base import Application

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'smarttv.report.project.settings')


class StandaloneApplication(Application):
    def init(self, parser, opts, args):
        pass

    def load(self):
        from django.core.wsgi import get_wsgi_application
        application = get_wsgi_application()

        from plus.utils.wsgi import patch_ylog
        patch_ylog()

        return application


def main():
    app = StandaloneApplication()
    app.run()


def manage():
    from django.core.management import execute_from_command_line
    execute_from_command_line(sys.argv)


if __name__ == '__main__':
    main()
