import yenv
from django.contrib import admin
from django.contrib.auth.models import Group, User
from plus.utils.yauth import YaAuthAdminSite


from smarttv.report.bugreport import models


class ReportAdminSite(YaAuthAdminSite):
    site_title = f'Report admin [{yenv.type}]'
    site_header = site_title


admin_site = ReportAdminSite()
admin_site.register(User)
admin_site.register(Group)


@admin.register(models.Report, site=admin_site)
class BugreportAdminView(admin.ModelAdmin):
    list_display = (
        'id',
        'email',
        'message',
        'reported_at',
        'manufacturer',
        'product_name',
        'model',
        'created_at',
        'file',
    )
    search_fields = ('email', 'reported_at')
