import logging

from rest_framework.exceptions import APIException, status
from rest_framework.views import exception_handler

logger = logging.getLogger(__name__)


class FileExists(APIException):
    status_code = status.HTTP_400_BAD_REQUEST
    default_detail = 'File already exists'
    default_code = 'file_exists'


# noinspection PyProtectedMember
def custom_exception_handler(exc, context):
    if isinstance(exc, APIException):
        logger.error(str(exc), exc_info=True)
    return exception_handler(exc, context)
