# Generated by Django 2.2.19 on 2021-03-17 12:03

from django.db import migrations, models
import django.utils.timezone


def copy_dates(apps, schema_editor):
    reports_model = apps.get_model('bugreport', 'Report')
    for report in reports_model.objects.all():
        report.created_at = report.updated_at


def reverse_copy_dates(apps, schema_editor):
    reports_model = apps.get_model('bugreport', 'Report')
    for report in reports_model.objects.all():
        report.updated_at = report.created_at


class Migration(migrations.Migration):

    dependencies = [
        ('bugreport', '0002_auto_20200525_1224'),
    ]

    operations = [
        migrations.AddField(
            model_name='report',
            name='created_at',
            field=models.DateTimeField(auto_now_add=True, default=django.utils.timezone.now),
            preserve_default=False,
        ),
        migrations.RunPython(
            code=copy_dates,
            reverse_code=reverse_copy_dates,
        ),
        migrations.RemoveField(
            model_name='report',
            name='updated_at',
        ),
    ]
