from django.db import models

from smarttv.report.bugreport import s3mds

S3_BUGREPORT_FOLDER = 'bugreport'


class Report(models.Model):
    email = models.CharField(max_length=255, default='', blank=True)
    message = models.TextField(null=True, blank=True)
    reported_at = models.DateTimeField()
    created_at = models.DateTimeField(auto_now_add=True)
    manufacturer = models.CharField(max_length=255, default='', blank=True)
    product_name = models.CharField(max_length=255, default='', blank=True)
    model = models.CharField(max_length=255, default='', blank=True)
    file = models.FileField('Report file', max_length=1024, blank=True, storage=s3mds.S3FileStorage(), upload_to=S3_BUGREPORT_FOLDER)
