from django.conf import settings
from django.conf.urls import url, include
from django.views.static import serve

from plus.utils.db.migrations import check_migrations

from smarttv.report.project.views import ping
from smarttv.report.bugreport.admin import admin_site

handler500 = 'rest_framework.exceptions.server_error'

urlpatterns = [
    url(r'^ping/?', ping, name='ping'),
    url(r'^check_migrations/?', check_migrations, name='check_migrations'),
    url(r'^api/', include('smarttv.report.bugreport.urls')),
    url(r'^report/admin/', admin_site.urls),
    url(r'^report/static/(?P<path>.*)$', serve, {'document_root': settings.STATIC_ROOT, 'show_indexes': False}),
    url(r'^%s' % settings.IDM_URL_PREFIX, include('django_idm_api.urls')),
]
