import re
from textwrap import wrap
import hashlib

MAC_PATTERN = re.compile(r'^([0-9a-f]{2}:){5}[0-9a-f]{2}$', re.I)


def validate_mac(mac):
    return isinstance(mac, str) and bool(MAC_PATTERN.match(mac))


def normalize_mac(mac):
    return ':'.join(wrap(mac.lower().strip().replace(':', ''), width=2))


def unfold_interval(line):
    if '-' in line:
        min, max = line.split('-')
        min, max = integer_mac(min), integer_mac(max)
        if min and max:
            return [integer_mac_to_string(address) for address in range(min, max+1)]


def integer_mac(mac):
    mac = normalize_mac(mac)
    if mac:
        return int(mac.replace(':', ''), 16)


def integer_mac_to_string(mac):
    return normalize_mac('{:012x}'.format(mac))


def quasar_device_id(platform, mac):
    platform_digest = hashlib.sha1(platform.lower().encode('ascii')).hexdigest()
    mac_digest = hashlib.sha1(mac.lower().encode('ascii')).hexdigest()
    return platform_digest[:4] + mac_digest[:16]
