from smarttv.utils.machelpers import normalize_mac, validate_mac


class TestValidateMac:
    def test_normal(self):
        assert validate_mac('aa:bb:cc:dd:ee:ff') is True

    def test_long(self):
        assert validate_mac('aa:bb:cc:dd:ee:ff:gg:dd') is False

    def test_plan_wrong(self):
        assert validate_mac('incorrect') is False


class TestNormalizeMac:
    def test_adding_colons(self):
        assert normalize_mac('aabbccddeeff') == 'aa:bb:cc:dd:ee:ff'

    def test_strip_and_lowercase(self):
        assert normalize_mac('  AAbb:CCddeeff ') == 'aa:bb:cc:dd:ee:ff'

    def test_incorrect(self):
        assert normalize_mac('aabbccddeeffgghh') == 'aa:bb:cc:dd:ee:ff:gg:hh'
